/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.rest;

import com.google.common.reflect.TypeToken;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.Attachments;
import com.microsoft.bot.connector.rest.ErrorResponseException;
import com.microsoft.bot.connector.rest.RestConnectorClient;
import com.microsoft.bot.restclient.ServiceResponse;
import com.microsoft.bot.schema.AttachmentInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Streaming;

public class RestAttachments
implements Attachments {
    private AttachmentsService service;
    private RestConnectorClient client;

    RestAttachments(Retrofit withRetrofit, RestConnectorClient withClient) {
        this.service = (AttachmentsService)withRetrofit.create(AttachmentsService.class);
        this.client = withClient;
    }

    @Override
    public CompletableFuture<AttachmentInfo> getAttachmentInfo(String attachmentId) {
        if (attachmentId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter attachmentId is required and cannot be null."));
        }
        return this.service.getAttachmentInfo(attachmentId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getAttachmentInfoDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getAttachmentInfoAsync", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<AttachmentInfo> getAttachmentInfoDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<AttachmentInfo>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    @Override
    public CompletableFuture<InputStream> getAttachment(String attachmentId, String viewId) {
        if (attachmentId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter attachmentId is required and cannot be null."));
        }
        if (viewId == null) {
            return Async.completeExceptionally(new IllegalArgumentException("Parameter viewId is required and cannot be null."));
        }
        return this.service.getAttachment(attachmentId, viewId, this.client.getAcceptLanguage(), this.client.getUserAgent()).thenApply(responseBodyResponse -> {
            try {
                return this.getAttachmentDelegate((Response<ResponseBody>)responseBodyResponse).body();
            }
            catch (ErrorResponseException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new ErrorResponseException("getAttachmentAsync", (Response<ResponseBody>)responseBodyResponse);
            }
        });
    }

    private ServiceResponse<InputStream> getAttachmentDelegate(Response<ResponseBody> response) throws ErrorResponseException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<InputStream>(){}.getType()).register(301, new TypeToken<Void>(){}.getType()).register(302, new TypeToken<Void>(){}.getType()).registerError(ErrorResponseException.class).build(response);
    }

    static interface AttachmentsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Attachments getAttachmentInfo"})
        @GET(value="v3/attachments/{attachmentId}")
        public CompletableFuture<Response<ResponseBody>> getAttachmentInfo(@Path(value="attachmentId") String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.bot.schema.Attachments getAttachment"})
        @GET(value="v3/attachments/{attachmentId}/views/{viewId}")
        @Streaming
        public CompletableFuture<Response<ResponseBody>> getAttachment(@Path(value="attachmentId") String var1, @Path(value="viewId") String var2, @Header(value="accept-language") String var3, @Header(value="User-Agent") String var4);
    }
}

