/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.auth0.jwt.JWT;
import com.microsoft.bot.connector.Async;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.ClaimsIdentity;
import com.microsoft.bot.connector.authentication.CredentialProvider;
import com.microsoft.bot.connector.authentication.JwtTokenValidation;
import com.microsoft.bot.connector.authentication.TokenValidationParameters;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class SkillValidation {
    private static final TokenValidationParameters TOKENVALIDATIONPARAMETERS = new TokenValidationParameters(true, Stream.of("https://sts.windows.net/d6d49420-f39b-4df7-a1dc-d59a935871db/", "https://login.microsoftonline.com/d6d49420-f39b-4df7-a1dc-d59a935871db/v2.0", "https://sts.windows.net/f8cdef31-a31e-4b4a-93e4-5f571e91255a/", "https://login.microsoftonline.com/f8cdef31-a31e-4b4a-93e4-5f571e91255a/v2.0", "https://sts.windows.net/cab8a31a-1906-4287-a0d8-4eef66b95f6e/", "https://login.microsoftonline.us/cab8a31a-1906-4287-a0d8-4eef66b95f6e/v2.0", "https://login.microsoftonline.us/f8cdef31-a31e-4b4a-93e4-5f571e91255a/", "https://login.microsoftonline.us/f8cdef31-a31e-4b4a-93e4-5f571e91255a/v2.0").collect(Collectors.toList()), false, true, Duration.ofMinutes(5L), true);

    private SkillValidation() {
    }

    public static Boolean isSkillClaim(Map<String, String> claims) {
        for (Map.Entry<String, String> entry : claims.entrySet()) {
            if (entry.getValue() != "AnonymousSkill" || entry.getKey() != "appid") continue;
            return true;
        }
        Optional<Map.Entry> version = claims.entrySet().stream().filter(x -> x.getKey() == "ver").findFirst();
        if (!version.isPresent()) {
            return false;
        }
        Optional<Map.Entry> audience = claims.entrySet().stream().filter(x -> x.getKey() == "aud").findFirst();
        if (!audience.isPresent() || "https://api.botframework.com" == audience.get().getValue()) {
            return false;
        }
        String appId = JwtTokenValidation.getAppIdFromClaims(claims);
        if (StringUtils.isBlank((CharSequence)appId)) {
            return false;
        }
        return !StringUtils.equals((CharSequence)appId, (CharSequence)((CharSequence)audience.get().getValue()));
    }

    public static boolean isSkillToken(String authHeader) {
        if (!JwtTokenValidation.isValidTokenFormat(authHeader)) {
            return false;
        }
        String bearerToken = authHeader.split(" ")[1];
        ClaimsIdentity identity = new ClaimsIdentity(JWT.decode((String)bearerToken));
        return SkillValidation.isSkillClaim(identity.claims());
    }

    public static CompletableFuture<Void> validateIdentity(ClaimsIdentity identity, CredentialProvider credentials) {
        if (identity == null) {
            return Async.completeExceptionally(new AuthenticationException("Invalid Identity"));
        }
        if (!identity.isAuthenticated()) {
            return Async.completeExceptionally(new AuthenticationException("Token Not Authenticated"));
        }
        Optional<Map.Entry> versionClaim = identity.claims().entrySet().stream().filter(item -> StringUtils.equals((CharSequence)"ver", (CharSequence)((CharSequence)item.getKey()))).findFirst();
        if (!versionClaim.isPresent()) {
            return Async.completeExceptionally(new AuthenticationException("ver claim is required on skill Tokens."));
        }
        Optional<Map.Entry> audienceClaim = identity.claims().entrySet().stream().filter(item -> StringUtils.equals((CharSequence)"aud", (CharSequence)((CharSequence)item.getKey()))).findFirst();
        if (!audienceClaim.isPresent() || StringUtils.isEmpty((CharSequence)((CharSequence)audienceClaim.get().getValue()))) {
            return Async.completeExceptionally(new AuthenticationException("aud claim is required on skill Tokens."));
        }
        String appId = JwtTokenValidation.getAppIdFromClaims(identity.claims());
        if (StringUtils.isEmpty((CharSequence)appId)) {
            return Async.completeExceptionally(new AuthenticationException("Invalid appId."));
        }
        return credentials.isValidAppId((String)audienceClaim.get().getValue()).thenApply(isValid -> {
            if (!isValid.booleanValue()) {
                throw new AuthenticationException("Invalid audience.");
            }
            return null;
        });
    }

    public static ClaimsIdentity createAnonymousSkillClaim() {
        HashMap<String, String> claims = new HashMap<String, String>();
        claims.put("appid", "AnonymousSkill");
        return new ClaimsIdentity("anonymous", "anonymous", claims);
    }
}

