/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import java.time.Duration;

public class RetryParams {
    public static final int MAX_RETRIES = 10;
    private static final Duration MAX_DELAY = Duration.ofSeconds(10L);
    private static final Duration DEFAULT_BACKOFF_TIME = Duration.ofMillis(50L);
    private boolean shouldRetry = true;
    private long retryAfter;

    public static RetryParams stopRetrying() {
        return new RetryParams(){
            {
                this.setShouldRetry(false);
            }
        };
    }

    public static RetryParams defaultBackOff(int retryCount) {
        return retryCount < 10 ? new RetryParams(DEFAULT_BACKOFF_TIME.toMillis()) : RetryParams.stopRetrying();
    }

    public RetryParams() {
    }

    public RetryParams(long withRetryAfter) {
        this.setRetryAfter(Math.min(withRetryAfter, MAX_DELAY.toMillis()));
    }

    public boolean getShouldRetry() {
        return this.shouldRetry;
    }

    public void setShouldRetry(boolean withShouldRetry) {
        this.shouldRetry = withShouldRetry;
    }

    public long getRetryAfter() {
        return this.retryAfter;
    }

    public void setRetryAfter(long withRetryAfter) {
        this.retryAfter = withRetryAfter;
    }
}

