/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.authentication.RetryException;
import com.microsoft.bot.connector.authentication.RetryParams;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public final class Retry {
    private static final double BACKOFF_MULTIPLIER = 1.1;

    private Retry() {
    }

    public static <TResult> CompletableFuture<TResult> run(Supplier<CompletableFuture<TResult>> task, BiFunction<RuntimeException, Integer, RetryParams> retryExceptionHandler) {
        return Retry.runInternal(task, retryExceptionHandler, 1, new ArrayList<Throwable>());
    }

    private static <TResult> CompletableFuture<TResult> runInternal(Supplier<CompletableFuture<TResult>> task, BiFunction<RuntimeException, Integer, RetryParams> retryExceptionHandler, Integer retryCount, List<Throwable> exceptions) {
        AtomicReference retry = new AtomicReference();
        return ((CompletableFuture)task.get().exceptionally(t -> {
            exceptions.add((Throwable)t);
            retry.set((RetryParams)retryExceptionHandler.apply(new RetryException((Throwable)t), retryCount));
            return null;
        })).thenCompose(taskResult -> {
            CompletableFuture<Object> result = new CompletableFuture<Object>();
            if (retry.get() == null) {
                result.complete(taskResult);
                return result;
            }
            if (((RetryParams)retry.get()).getShouldRetry()) {
                try {
                    Thread.sleep(Retry.withBackOff(((RetryParams)retry.get()).getRetryAfter(), retryCount));
                }
                catch (InterruptedException e) {
                    throw new RetryException(e);
                }
                return Retry.runInternal(task, retryExceptionHandler, retryCount + 1, exceptions);
            }
            result.completeExceptionally(new RetryException("Exceeded retry count", exceptions));
            return result;
        });
    }

    private static long withBackOff(long delay, int retryCount) {
        double result = (double)delay * Math.pow(1.1, retryCount - 1);
        return (long)Math.min(result, 9.223372036854776E18);
    }
}

