/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.authentication.AppCredentials;
import com.microsoft.bot.connector.authentication.Authenticator;
import com.microsoft.bot.connector.authentication.CredentialsAuthenticator;
import com.microsoft.bot.connector.authentication.OAuthConfiguration;
import java.net.MalformedURLException;

public class MicrosoftAppCredentials
extends AppCredentials {
    public static final String MICROSOFTAPPID = "MicrosoftAppId";
    public static final String MICROSOFTAPPPASSWORD = "MicrosoftAppPassword";
    private String appPassword;

    public static MicrosoftAppCredentials empty() {
        return new MicrosoftAppCredentials(null, null);
    }

    public MicrosoftAppCredentials(String withAppId, String withAppPassword) {
        this(withAppId, withAppPassword, null);
    }

    public MicrosoftAppCredentials(String withAppId, String withAppPassword, String withChannelAuthTenant) {
        super(withChannelAuthTenant);
        this.setAppId(withAppId);
        this.setAppPassword(withAppPassword);
    }

    public MicrosoftAppCredentials(String withAppId, String withAppPassword, String withChannelAuthTenant, String withOAuthScope) {
        super(withChannelAuthTenant, withOAuthScope);
        this.setAppId(withAppId);
        this.setAppPassword(withAppPassword);
    }

    public String getAppPassword() {
        return this.appPassword;
    }

    public void setAppPassword(String withAppPassword) {
        this.appPassword = withAppPassword;
    }

    @Override
    protected Authenticator buildAuthenticator() throws MalformedURLException {
        return new CredentialsAuthenticator(this.getAppId(), this.getAppPassword(), new OAuthConfiguration(this.oAuthEndpoint(), this.oAuthScope()));
    }
}

