/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.Authenticator;
import com.microsoft.bot.connector.authentication.OAuthConfiguration;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;

public class CredentialsAuthenticator
implements Authenticator {
    private ConfidentialClientApplication app;
    private ClientCredentialParameters parameters;

    CredentialsAuthenticator(String appId, String appPassword, OAuthConfiguration configuration) throws MalformedURLException {
        this.app = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)appId, (IClientCredential)ClientCredentialFactory.createFromSecret((String)appPassword)).authority(configuration.getAuthority())).build();
        this.parameters = ClientCredentialParameters.builder(Collections.singleton(configuration.getScope())).build();
    }

    @Override
    public CompletableFuture<IAuthenticationResult> acquireToken() {
        return this.app.acquireToken(this.parameters).exceptionally(exception -> {
            throw new AuthenticationException((Throwable)exception);
        });
    }
}

