/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.bot.connector.authentication.AppCredentials;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

public class AppCredentialsInterceptor
implements Interceptor {
    private AppCredentials credentials;

    public AppCredentialsInterceptor(AppCredentials withCredentials) {
        this.credentials = withCredentials;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.credentials.shouldSetToken(chain.request().url().url().toString())) {
            String token;
            try {
                token = this.credentials.getToken().get();
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
            Request newRequest = chain.request().newBuilder().header("Authorization", "Bearer " + token).build();
            return chain.proceed(newRequest);
        }
        return chain.proceed(chain.request());
    }
}

