/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bot.connector.authentication;

import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.bot.connector.authentication.AppCredentialsInterceptor;
import com.microsoft.bot.connector.authentication.AuthenticationException;
import com.microsoft.bot.connector.authentication.Authenticator;
import com.microsoft.bot.connector.authentication.MicrosoftAppCredentials;
import com.microsoft.bot.restclient.credentials.ServiceClientCredentials;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.OkHttpClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public abstract class AppCredentials
implements ServiceClientCredentials {
    private static final int EXPIRATION_SLACK = 5;
    private static final int EXPIRATION_DAYS = 1;
    private static ConcurrentMap<String, LocalDateTime> trustHostNames = new ConcurrentHashMap<String, LocalDateTime>();
    private String appId;
    private String authTenant;
    private String authScope;
    private Authenticator authenticator;

    public AppCredentials(String withChannelAuthTenant) {
        this(withChannelAuthTenant, "https://api.botframework.com/.default");
    }

    public AppCredentials(String withChannelAuthTenant, String withOAuthScope) {
        this.setChannelAuthTenant(withChannelAuthTenant);
        this.authScope = StringUtils.isEmpty((CharSequence)withOAuthScope) ? "https://api.botframework.com/.default" : withOAuthScope;
    }

    public static void trustServiceUrl(String serviceUrl) {
        AppCredentials.trustServiceUrl(serviceUrl, LocalDateTime.now().plusDays(1L));
    }

    public static void trustServiceUrl(String serviceUrl, LocalDateTime expirationTime) {
        try {
            URL url = new URL(serviceUrl);
            AppCredentials.trustServiceUrl(url, expirationTime);
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(MicrosoftAppCredentials.class).error("trustServiceUrl", (Throwable)e);
        }
    }

    public static void trustServiceUrl(URL serviceUrl, LocalDateTime expirationTime) {
        trustHostNames.put(serviceUrl.getHost(), expirationTime);
    }

    public static boolean isTrustedServiceUrl(String serviceUrl) {
        try {
            URL url = new URL(serviceUrl);
            return AppCredentials.isTrustedServiceUrl(url);
        }
        catch (MalformedURLException e) {
            LoggerFactory.getLogger(AppCredentials.class).error("trustServiceUrl", (Throwable)e);
            return false;
        }
    }

    public static boolean isTrustedServiceUrl(URL serviceUrl) {
        return !trustHostNames.getOrDefault(serviceUrl.getHost(), LocalDateTime.MIN).isBefore(LocalDateTime.now().minusMinutes(5L));
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String withAppId) {
        this.appId = withAppId;
    }

    public String getChannelAuthTenant() {
        return StringUtils.isEmpty((CharSequence)this.authTenant) ? "botframework.com" : this.getAuthTenant();
    }

    public void setChannelAuthTenant(String withAuthTenant) {
        try {
            String endPointUrl = String.format("https://login.microsoftonline.com/%s", withAuthTenant);
            new URL(endPointUrl).toString();
            this.setAuthTenant(withAuthTenant);
        }
        catch (MalformedURLException e) {
            throw new AuthenticationException("Invalid channel auth tenant: " + withAuthTenant);
        }
    }

    public String oAuthEndpoint() {
        return String.format("https://login.microsoftonline.com/%s", this.getChannelAuthTenant());
    }

    public String oAuthScope() {
        return this.authScope;
    }

    protected String getAuthTenant() {
        return this.authTenant;
    }

    protected void setAuthTenant(String withAuthTenant) {
        this.authTenant = withAuthTenant;
    }

    public CompletableFuture<String> getToken() {
        CompletableFuture<String> result;
        try {
            result = this.getAuthenticator().acquireToken().thenApply(IAuthenticationResult::accessToken);
        }
        catch (MalformedURLException e) {
            result = new CompletableFuture<String>();
            result.completeExceptionally(new AuthenticationException(e));
        }
        return result;
    }

    boolean shouldSetToken(String url) {
        return AppCredentials.isTrustedServiceUrl(url);
    }

    private Authenticator getAuthenticator() throws MalformedURLException {
        if (this.authenticator == null) {
            this.authenticator = this.buildAuthenticator();
        }
        return this.authenticator;
    }

    protected abstract Authenticator buildAuthenticator() throws MalformedURLException;

    @Override
    public void applyCredentialsFilter(OkHttpClient.Builder clientBuilder) {
        clientBuilder.interceptors().add(new AppCredentialsInterceptor(this));
    }

    static {
        trustHostNames.put("api.botframework.com", LocalDateTime.MAX);
        trustHostNames.put("token.botframework.com", LocalDateTime.MAX);
        trustHostNames.put("api.botframework.azure.us", LocalDateTime.MAX);
        trustHostNames.put("token.botframework.azure.us", LocalDateTime.MAX);
    }
}

