/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.reporting;

import com.microsoft.bingads.v13.internal.reporting.RowReportRecord;
import com.microsoft.bingads.v13.internal.reporting.RowReportStreamReader;
import com.microsoft.bingads.v13.reporting.ReportRecord;
import java.util.ArrayList;
import java.util.Iterator;

class RowReportRecordIterator
implements Iterator<ReportRecord> {
    private RowReportStreamReader reader;
    private Iterator<ReportRecord> nextBatch = null;

    RowReportRecordIterator(RowReportStreamReader reportStreamReader) {
        this.reader = reportStreamReader;
    }

    @Override
    public boolean hasNext() {
        this.updateNextBatch();
        return this.nextBatch != null && this.nextBatch.hasNext();
    }

    @Override
    public ReportRecord next() {
        this.updateNextBatch();
        if (this.nextBatch != null && this.nextBatch.hasNext()) {
            ReportRecord returnEntity = this.nextBatch.next();
            return returnEntity;
        }
        throw new UnsupportedOperationException("Invalid report object returned!!!");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void updateNextBatch() {
        if (this.nextBatch == null || !this.nextBatch.hasNext()) {
            this.nextBatch = this.readNextBatch();
        }
    }

    private Iterator<ReportRecord> readNextBatch() {
        RowReportRecord next = this.reader.read();
        if (next == null) {
            return null;
        }
        ArrayList<RowReportRecord> records = new ArrayList<RowReportRecord>();
        records.add(next);
        return records.iterator();
    }
}

