/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.internal.reporting;

import com.microsoft.bingads.v13.reporting.CouldNotGetReportingMetadataException;
import com.microsoft.bingads.v13.reporting.ReportAggregation;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class ReportHeader {
    private String reportName;
    private long recordCount = -1L;
    private String[] reportColumns;
    private Date reportTimeStart;
    private Date reportTimeEnd;
    private String timeZone;
    private ReportAggregation reportAggregation;
    private Date lastCompletedAvailableDate;
    private boolean potentialIncompleteData;

    public Date getLastCompletedAvailableDate() {
        return this.lastCompletedAvailableDate;
    }

    public void setLastCompletedAvailableDate(String strLastCompletedAvailableDate) {
        if (strLastCompletedAvailableDate == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss a (Z)");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            this.lastCompletedAvailableDate = format.parse(strLastCompletedAvailableDate);
        }
        catch (ParseException e) {
            System.out.println("Can not parse report LastCompletedAvailableDate from file.");
        }
    }

    public String getReportName() {
        return this.reportName;
    }

    public String[] getReportColumns() {
        return this.reportColumns;
    }

    public Date getReportTimeStart() {
        return this.reportTimeStart;
    }

    public Date getReportTimeEnd() {
        return this.reportTimeEnd;
    }

    public void setReportTime(String strReportTime) {
        if (strReportTime == null) {
            return;
        }
        SimpleDateFormat format = new SimpleDateFormat("MM/dd/yyyy");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            String[] reportTime = strReportTime.split(",");
            if (reportTime.length == 1) {
                this.reportTimeEnd = this.reportTimeStart = format.parse(reportTime[0].trim());
            } else if (reportTime.length == 2) {
                this.reportTimeStart = format.parse(reportTime[0].trim());
                this.reportTimeEnd = format.parse(reportTime[1].trim());
            }
        }
        catch (ParseException e) {
            System.out.println("Can not parse Report Time from file.");
        }
    }

    public String getReportTimeZone() {
        return this.timeZone;
    }

    public void setReportTimeZone(String strReportTimeZone) {
        this.timeZone = strReportTimeZone;
    }

    public long getReportRecordCount() throws CouldNotGetReportingMetadataException {
        if (this.recordCount == -1L) {
            throw new CouldNotGetReportingMetadataException("RecordCount");
        }
        return this.recordCount;
    }

    public ReportAggregation getReportAggregation() {
        return this.reportAggregation;
    }

    public void setReportAggregation(String reportAggregation) {
        try {
            this.reportAggregation = ReportAggregation.fromValue(reportAggregation);
        }
        catch (Exception e) {
            System.out.println("Can not parse report Aggregation from file.");
        }
    }

    public void setReportName(String name) {
        this.reportName = name;
    }

    protected void setReportFilter(String reportFilter) {
    }

    public boolean setReportColumns(String[] columns) {
        for (String s : columns) {
            if (!s.matches("^(([1-9]\\d*\\.?\\d*)|(0\\.\\d*[1-9]))%?$")) continue;
            return false;
        }
        this.reportColumns = columns;
        return true;
    }

    protected void setReportRecordCount(String recordCount) {
        try {
            this.recordCount = Long.parseLong(recordCount);
        }
        catch (Exception e) {
            System.out.println("Can not parse report ReportRecordCount from file.");
        }
    }

    public boolean getPotentialIncompleteData() {
        return this.potentialIncompleteData;
    }

    public void setPotentialIncompleteData(String potentialIncompleteData) {
        try {
            this.potentialIncompleteData = Boolean.parseBoolean(potentialIncompleteData);
        }
        catch (Exception e) {
            System.out.println("Can not parse report PotentialIncompleteData from file.");
        }
    }
}

