/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdExtension;
import com.microsoft.bingads.v13.campaignmanagement.ArrayOfstring;
import com.microsoft.bingads.v13.campaignmanagement.VideoAdExtension;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkVideoAdExtension
extends BulkAdExtension<VideoAdExtension> {
    private static final List<BulkMapping<BulkVideoAdExtension>> MAPPINGS;

    public VideoAdExtension getVideoAdExtension() {
        return (VideoAdExtension)this.getAdExtension();
    }

    public void setVideoAdExtension(VideoAdExtension videoAdExtension) {
        this.setAdExtension(videoAdExtension);
    }

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        VideoAdExtension extension = new VideoAdExtension();
        extension.setType("VideoAdExtension");
        this.setAdExtension(extension);
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getVideoAdExtension(), "VideoAdExtension");
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkVideoAdExtension, String>> m = new ArrayList<SimpleBulkMapping<BulkVideoAdExtension, String>>();
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Name", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toOptionalBulkString(((VideoAdExtension)c.getAdExtension()).getName(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setName(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Display Text", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toOptionalBulkString(((VideoAdExtension)c.getAdExtension()).getDisplayText(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setDisplayText(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Alternative Text", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toOptionalBulkString(((VideoAdExtension)c.getAdExtension()).getAlternativeText(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setAlternativeText(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Action Text", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toOptionalBulkString(((VideoAdExtension)c.getAdExtension()).getActionText(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setActionText(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Thumbnail Url", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension t) {
                return t.getVideoAdExtension().getThumbnailUrl();
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                c.getVideoAdExtension().setThumbnailUrl(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Thumbnail Id", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toBulkString(((VideoAdExtension)c.getAdExtension()).getThumbnailId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setThumbnailId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Video Id", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toBulkString(((VideoAdExtension)c.getAdExtension()).getVideoId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setVideoId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Final Url", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.writeUrls("; ", ((VideoAdExtension)c.getAdExtension()).getFinalUrls(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((VideoAdExtension)c.getAdExtension()).setFinalUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Mobile Final Url", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.writeUrls("; ", ((VideoAdExtension)c.getAdExtension()).getFinalMobileUrls(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ArrayOfstring urls = new ArrayOfstring();
                List<String> urlArray = StringExtensions.parseUrls(v);
                if (urlArray == null) {
                    urls = null;
                } else {
                    urls.getStrings().addAll(urlArray);
                }
                ((VideoAdExtension)c.getAdExtension()).setFinalMobileUrls(urls);
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Tracking Template", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension t) {
                return StringExtensions.toOptionalBulkString(((VideoAdExtension)t.getAdExtension()).getTrackingUrlTemplate(), ((VideoAdExtension)t.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setTrackingUrlTemplate(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Custom Parameter", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toCustomParaBulkString(((VideoAdExtension)c.getAdExtension()).getUrlCustomParameters(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                try {
                    ((VideoAdExtension)c.getAdExtension()).setUrlCustomParameters(StringExtensions.parseCustomParameters(v));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkVideoAdExtension, String>("Final Url Suffix", new Function<BulkVideoAdExtension, String>(){

            @Override
            public String apply(BulkVideoAdExtension c) {
                return StringExtensions.toOptionalBulkString(((VideoAdExtension)c.getAdExtension()).getFinalUrlSuffix(), ((VideoAdExtension)c.getAdExtension()).getId());
            }
        }, new BiConsumer<String, BulkVideoAdExtension>(){

            @Override
            public void accept(String v, BulkVideoAdExtension c) {
                ((VideoAdExtension)c.getAdExtension()).setFinalUrlSuffix(StringExtensions.getValueOrEmptyString(v));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

