/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCustomerListItem
extends SingleRecordBulkEntity {
    private Long parentId;
    private String audience;
    private String subType;
    private String text;
    private static final List<BulkMapping<BulkCustomerListItem>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public Long getParentId() {
        return this.parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCustomerListItem, Object>> m = new ArrayList<SimpleBulkMapping<BulkCustomerListItem, Object>>();
        m.add(new SimpleBulkMapping<BulkCustomerListItem, Long>("Parent Id", new Function<BulkCustomerListItem, Long>(){

            @Override
            public Long apply(BulkCustomerListItem c) {
                return c.getParentId();
            }
        }, new BiConsumer<String, BulkCustomerListItem>(){

            @Override
            public void accept(String v, BulkCustomerListItem c) {
                c.setParentId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomerListItem, String>("Audience", new Function<BulkCustomerListItem, String>(){

            @Override
            public String apply(BulkCustomerListItem c) {
                return c.getAudience();
            }
        }, new BiConsumer<String, BulkCustomerListItem>(){

            @Override
            public void accept(String v, BulkCustomerListItem c) {
                c.setAudience(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomerListItem, String>("Sub Type", new Function<BulkCustomerListItem, String>(){

            @Override
            public String apply(BulkCustomerListItem c) {
                return c.getSubType();
            }
        }, new BiConsumer<String, BulkCustomerListItem>(){

            @Override
            public void accept(String v, BulkCustomerListItem c) {
                c.setSubType(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCustomerListItem, String>("Text", new Function<BulkCustomerListItem, String>(){

            @Override
            public String apply(BulkCustomerListItem c) {
                return c.getText();
            }
        }, new BiConsumer<String, BulkCustomerListItem>(){

            @Override
            public void accept(String v, BulkCustomerListItem c) {
                c.setText(v);
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

