/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.Status;
import com.microsoft.bingads.v13.campaignmanagement.NegativeCampaignCriterion;
import com.microsoft.bingads.v13.campaignmanagement.StoreCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import com.microsoft.bingads.v13.internal.bulk.entities.SingleRecordBulkEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignNegativeStoreCriterion
extends SingleRecordBulkEntity {
    private NegativeCampaignCriterion negativeCampaignCriterion;
    private Status status;
    private String campaignName;
    private static final List<BulkMapping<BulkCampaignNegativeStoreCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        NegativeCampaignCriterion negativeCampaignCriterion = new NegativeCampaignCriterion();
        StoreCriterion criterion = new StoreCriterion();
        negativeCampaignCriterion.setCriterion(criterion);
        negativeCampaignCriterion.setType(NegativeCampaignCriterion.class.getSimpleName());
        negativeCampaignCriterion.getCriterion().setType(StoreCriterion.class.getSimpleName());
        this.setNegativeCampaignCriterion(negativeCampaignCriterion);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        this.validatePropertyNotNull(this.getNegativeCampaignCriterion(), NegativeCampaignCriterion.class.getSimpleName());
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public NegativeCampaignCriterion getNegativeCampaignCriterion() {
        return this.negativeCampaignCriterion;
    }

    public void setNegativeCampaignCriterion(NegativeCampaignCriterion negativeCampaignCriterion) {
        this.negativeCampaignCriterion = negativeCampaignCriterion;
    }

    public String getCampaignName() {
        return this.campaignName;
    }

    public void setCampaignName(String campaignName) {
        this.campaignName = campaignName;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignNegativeStoreCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignNegativeStoreCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignNegativeStoreCriterion, String>("Status", new Function<BulkCampaignNegativeStoreCriterion, String>(){

            @Override
            public String apply(BulkCampaignNegativeStoreCriterion c) {
                return c.getStatus() != null ? c.getStatus().value() : null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeStoreCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeStoreCriterion c) {
                c.setStatus(StringExtensions.parseOptional(v, new Function<String, Status>(){

                    @Override
                    public Status apply(String value) {
                        return Status.fromValue(value);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeStoreCriterion, Long>("Id", new Function<BulkCampaignNegativeStoreCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeStoreCriterion c) {
                return c.getNegativeCampaignCriterion().getId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeStoreCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeStoreCriterion c) {
                c.getNegativeCampaignCriterion().setId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String s) {
                        return Long.parseLong(s);
                    }
                }));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeStoreCriterion, Long>("Parent Id", new Function<BulkCampaignNegativeStoreCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeStoreCriterion c) {
                return c.getNegativeCampaignCriterion().getCampaignId();
            }
        }, new BiConsumer<String, BulkCampaignNegativeStoreCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeStoreCriterion c) {
                c.getNegativeCampaignCriterion().setCampaignId(StringExtensions.nullOrLong(v));
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeStoreCriterion, String>("Campaign", new Function<BulkCampaignNegativeStoreCriterion, String>(){

            @Override
            public String apply(BulkCampaignNegativeStoreCriterion c) {
                return c.getCampaignName();
            }
        }, new BiConsumer<String, BulkCampaignNegativeStoreCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeStoreCriterion c) {
                c.setCampaignName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignNegativeStoreCriterion, Long>("Store Id", new Function<BulkCampaignNegativeStoreCriterion, Long>(){

            @Override
            public Long apply(BulkCampaignNegativeStoreCriterion c) {
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof StoreCriterion) {
                    return ((StoreCriterion)c.getNegativeCampaignCriterion().getCriterion()).getStoreId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignNegativeStoreCriterion>(){

            @Override
            public void accept(String v, BulkCampaignNegativeStoreCriterion c) {
                Long storeId = StringExtensions.nullOrLong(v);
                if (c.getNegativeCampaignCriterion().getCriterion() instanceof StoreCriterion && storeId != null) {
                    ((StoreCriterion)c.getNegativeCampaignCriterion().getCriterion()).setStoreId(storeId);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

