/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkCampaignBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.DeviceCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignDeviceCriterion
extends BulkCampaignBiddableCriterion {
    private static final List<BulkMapping<BulkCampaignDeviceCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        return new DeviceCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignDeviceCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkCampaignDeviceCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("Target", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).getDeviceName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).setDeviceName(v);
                }
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignDeviceCriterion, String>("OS Names", new Function<BulkCampaignDeviceCriterion, String>(){

            @Override
            public String apply(BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    return ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).getOSName();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignDeviceCriterion>(){

            @Override
            public void accept(String v, BulkCampaignDeviceCriterion c) {
                if (c.getBiddableCampaignCriterion().getCriterion() instanceof DeviceCriterion) {
                    ((DeviceCriterion)c.getBiddableCampaignCriterion().getCriterion()).setOSName(v);
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

