/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkCampaignBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.AudienceCriterion;
import com.microsoft.bingads.v13.campaignmanagement.BiddableCampaignCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkCampaignAudienceAssociation
extends BulkCampaignBiddableCriterion {
    private String audienceName;
    private static final List<BulkMapping<BulkCampaignAudienceAssociation>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        return new AudienceCriterion();
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public String getAudienceName() {
        return this.audienceName;
    }

    public void setAudienceName(String audienceName) {
        this.audienceName = audienceName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkCampaignAudienceAssociation, Object>> m = new ArrayList<SimpleBulkMapping<BulkCampaignAudienceAssociation, Object>>();
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, String>("Audience", new Function<BulkCampaignAudienceAssociation, String>(){

            @Override
            public String apply(BulkCampaignAudienceAssociation c) {
                return c.getAudienceName();
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                c.setAudienceName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkCampaignAudienceAssociation, Long>("Audience Id", new Function<BulkCampaignAudienceAssociation, Long>(){

            @Override
            public Long apply(BulkCampaignAudienceAssociation c) {
                if (c.getBiddableCampaignCriterion() instanceof BiddableCampaignCriterion) {
                    AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableCampaignCriterion().getCriterion();
                    if (audienceCriterion == null) {
                        return null;
                    }
                    return audienceCriterion.getAudienceId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkCampaignAudienceAssociation>(){

            @Override
            public void accept(String v, BulkCampaignAudienceAssociation c) {
                AudienceCriterion audienceCriterion = (AudienceCriterion)c.getBiddableCampaignCriterion().getCriterion();
                if (audienceCriterion == null) {
                    return;
                }
                audienceCriterion.setAudienceId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                    @Override
                    public Long apply(String value) {
                        return Long.parseLong(value);
                    }
                }));
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

