/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupNegativeCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.ProfileCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class BulkAdGroupNegativeProfileCriterion
extends BulkAdGroupNegativeCriterion {
    private String profileName;
    private static final List<BulkMapping<BulkAdGroupNegativeProfileCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    protected Criterion createCriterion() {
        ProfileCriterion criterion = new ProfileCriterion();
        this.setProfileType(criterion);
        return criterion;
    }

    public abstract void setProfileType(ProfileCriterion var1);

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Object>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Object>>();
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, String>("Profile", new Function<BulkAdGroupNegativeProfileCriterion, String>(){

            @Override
            public String apply(BulkAdGroupNegativeProfileCriterion c) {
                return c.getProfileName();
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                c.setProfileName(v);
            }
        }));
        m.add(new SimpleBulkMapping<BulkAdGroupNegativeProfileCriterion, Long>("Profile Id", new Function<BulkAdGroupNegativeProfileCriterion, Long>(){

            @Override
            public Long apply(BulkAdGroupNegativeProfileCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof ProfileCriterion) {
                    return ((ProfileCriterion)c.getNegativeAdGroupCriterion().getCriterion()).getProfileId();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupNegativeProfileCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupNegativeProfileCriterion c) {
                if (c.getNegativeAdGroupCriterion().getCriterion() instanceof ProfileCriterion) {
                    ((ProfileCriterion)c.getNegativeAdGroupCriterion().getCriterion()).setProfileId(StringExtensions.parseOptional(v, new Function<String, Long>(){

                        @Override
                        public Long apply(String s) {
                            return Long.parseLong(s);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

