/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.internal.functionalinterfaces.BiConsumer;
import com.microsoft.bingads.internal.functionalinterfaces.Function;
import com.microsoft.bingads.v13.bulk.entities.BulkAdGroupBiddableCriterion;
import com.microsoft.bingads.v13.campaignmanagement.Criterion;
import com.microsoft.bingads.v13.campaignmanagement.Day;
import com.microsoft.bingads.v13.campaignmanagement.HotelCheckInDayCriterion;
import com.microsoft.bingads.v13.internal.bulk.BulkMapping;
import com.microsoft.bingads.v13.internal.bulk.MappingHelpers;
import com.microsoft.bingads.v13.internal.bulk.RowValues;
import com.microsoft.bingads.v13.internal.bulk.SimpleBulkMapping;
import com.microsoft.bingads.v13.internal.bulk.StringExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BulkAdGroupHotelCheckInDayCriterion
extends BulkAdGroupBiddableCriterion {
    private static final List<BulkMapping<BulkAdGroupHotelCheckInDayCriterion>> MAPPINGS;

    @Override
    public void processMappingsFromRowValues(RowValues values) {
        super.processMappingsFromRowValues(values);
        MappingHelpers.convertToEntity(values, MAPPINGS, this);
    }

    @Override
    public void processMappingsToRowValues(RowValues values, boolean excludeReadonlyData) {
        super.processMappingsToRowValues(values, excludeReadonlyData);
        MappingHelpers.convertToValues(this, values, MAPPINGS);
    }

    @Override
    protected Criterion createCriterion() {
        return new HotelCheckInDayCriterion();
    }

    static {
        ArrayList<SimpleBulkMapping<BulkAdGroupHotelCheckInDayCriterion, String>> m = new ArrayList<SimpleBulkMapping<BulkAdGroupHotelCheckInDayCriterion, String>>();
        m.add(new SimpleBulkMapping<BulkAdGroupHotelCheckInDayCriterion, String>("Target", new Function<BulkAdGroupHotelCheckInDayCriterion, String>(){

            @Override
            public String apply(BulkAdGroupHotelCheckInDayCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelCheckInDayCriterion) {
                    HotelCheckInDayCriterion criterion = (HotelCheckInDayCriterion)c.getBiddableAdGroupCriterion().getCriterion();
                    return criterion == null || criterion.getCheckInDay() == null ? null : criterion.getCheckInDay().value();
                }
                return null;
            }
        }, new BiConsumer<String, BulkAdGroupHotelCheckInDayCriterion>(){

            @Override
            public void accept(String v, BulkAdGroupHotelCheckInDayCriterion c) {
                if (c.getBiddableAdGroupCriterion().getCriterion() instanceof HotelCheckInDayCriterion) {
                    ((HotelCheckInDayCriterion)c.getBiddableAdGroupCriterion().getCriterion()).setCheckInDay(StringExtensions.parseOptional(v, new Function<String, Day>(){

                        @Override
                        public Day apply(String t) {
                            return Day.fromValue(t);
                        }
                    }));
                }
            }
        }));
        MAPPINGS = Collections.unmodifiableList(m);
    }
}

