/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.bingads.internal;

import com.microsoft.bingads.InternalException;
import com.microsoft.bingads.internal.ServiceUtils;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPHeader;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;

public class HeaderHandler
implements SOAPHandler<SOAPMessageContext> {
    private final Map<String, String> headers;
    private final String namespaceURI;

    public HeaderHandler(String namespaceURI, Map<String, String> headers) {
        this.headers = headers;
        this.namespaceURI = namespaceURI;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        try {
            Boolean outbound = (Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound");
            if (outbound.booleanValue()) {
                SOAPMessage message = context.getMessage();
                SOAPHeader header = message.getSOAPHeader();
                SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
                if (header == null) {
                    header = envelope.addHeader();
                }
                for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                    header.addHeaderElement(new QName(this.namespaceURI, entry.getKey())).addTextNode(entry.getValue());
                }
            } else {
                String headerValue = this.getSpecificHeaderValue(context.getMessage().getSOAPHeader(), ServiceUtils.TRACKING_HEADER_NAME);
                if (headerValue != null) {
                    context.put((Object)ServiceUtils.TRACKING_KEY, (Object)headerValue);
                    context.setScope(ServiceUtils.TRACKING_KEY, MessageContext.Scope.APPLICATION);
                }
            }
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
        return true;
    }

    private String getSpecificHeaderValue(SOAPHeader header, String localName) {
        return header != null && header.getFirstChild() != null && header.getFirstChild().getLocalName() != null && header.getFirstChild().getLocalName().equals(localName) ? header.getFirstChild().getTextContent() : null;
    }

    public Set getHeaders() {
        return null;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

