package com.microsoft.bingads.v13.bulk.entities;

import com.microsoft.bingads.v13.bulk.BulkFileReader;
import com.microsoft.bingads.v13.bulk.BulkFileWriter;
import com.microsoft.bingads.v13.bulk.BulkOperation;
import com.microsoft.bingads.v13.bulk.BulkServiceManager;

/**
 * Represents an ad group level filter link ad extension. This class exposes
 * properties that can be read and written as fields of the Ad Group Filter Link Ad
 * Extension record in a bulk file.
 *
 * <p>
 * For more information, see Ad Group Filter Link Ad Extension at
 * <a href="https://go.microsoft.com/fwlink/?linkid=846127">https://go.microsoft.com/fwlink/?linkid=846127</a>.
 * </p>
 *
 * @see BulkServiceManager
 * @see BulkOperation
 * @see BulkFileReader
 * @see BulkFileWriter
 *
 */
public class BulkAdGroupFilterLinkAdExtension extends BulkAdGroupAdExtension {
}
