/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.spring.cloud.config;

import com.azure.data.appconfiguration.models.ConfigurationSetting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class StateHolder {
    private static final Map<String, ConfigurationSetting> etagState = new ConcurrentHashMap<String, ConfigurationSetting>();
    private static final Map<String, Boolean> loadState = new ConcurrentHashMap<String, Boolean>();

    private StateHolder() {
        throw new IllegalStateException("Should not be callable.");
    }

    public static ConfigurationSetting getEtagState(String name) {
        return etagState.get(name);
    }

    static void setEtagState(String name, ConfigurationSetting config) {
        etagState.put(name, config);
    }

    static boolean getLoadState(String name) {
        return loadState.getOrDefault(name, false);
    }

    public static void setLoadState(String name, Boolean loaded) {
        loadState.put(name, loaded);
    }
}

