/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.exceptions;

import com.azure.core.exception.AzureException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.azure.kusto.data.exceptions.DataWebException;
import com.microsoft.azure.kusto.data.exceptions.OneApiError;
import java.util.ArrayList;
import java.util.List;

public class KustoServiceQueryError
extends AzureException {
    static final String EXCEPTIONS_MESSAGE = "Query execution failed with multiple inner exceptions:\n";
    private final List<RuntimeException> exceptions;

    public KustoServiceQueryError(String message, List<RuntimeException> exceptions) {
        super(message);
        this.exceptions = exceptions;
    }

    public KustoServiceQueryError(String message) {
        super(message);
        this.exceptions = new ArrayList<RuntimeException>();
        this.exceptions.add(new RuntimeException(message));
    }

    public static KustoServiceQueryError fromOneApiErrorArray(ArrayNode jsonExceptions, boolean isOneApi) {
        ArrayList<RuntimeException> exceptions = new ArrayList<RuntimeException>();
        StringBuilder sb = new StringBuilder();
        if (jsonExceptions == null || jsonExceptions.isEmpty()) {
            return new KustoServiceQueryError("No exceptions were returned from the service.");
        }
        if (jsonExceptions.size() > 1) {
            sb.append(EXCEPTIONS_MESSAGE);
        }
        for (int i = 0; i < jsonExceptions.size(); ++i) {
            Object exception;
            String value;
            JsonNode jsonNode = jsonExceptions.get(i);
            String message = value = jsonNode.isTextual() ? jsonNode.asText() : jsonNode.toString();
            if (isOneApi) {
                DataWebException ex = new DataWebException(value);
                OneApiError apiError = ex.getApiError();
                if (apiError != null) {
                    message = apiError.getCode() + ": " + apiError.getMessage();
                }
                exception = ex;
            } else {
                exception = new RuntimeException(value);
            }
            exceptions.add((RuntimeException)exception);
            sb.append(message);
            sb.append("\n");
        }
        return new KustoServiceQueryError(sb.toString(), exceptions);
    }

    public List<RuntimeException> getExceptions() {
        return this.exceptions;
    }

    public String toString() {
        return this.exceptions.isEmpty() ? this.getMessage() : "exceptions\":" + this.exceptions + "}";
    }

    public boolean isPermanent() {
        if (!this.exceptions.isEmpty() && this.exceptions.get(0) instanceof DataWebException) {
            return ((DataWebException)((Object)this.exceptions.get(0))).getApiError().isPermanent();
        }
        return false;
    }
}

