/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtils {
    public static final String EMPTY = "";

    private StringUtils() {
    }

    @NotNull
    public static String getStringTail(String val, int minRuleLength) {
        if (minRuleLength <= 0) {
            return EMPTY;
        }
        if (minRuleLength >= val.length()) {
            return val;
        }
        return val.substring(val.length() - minRuleLength);
    }

    public static String normalizeEntityName(String name) {
        if (StringUtils.isBlank(name)) {
            return name;
        }
        if (name.startsWith("[")) {
            return name;
        }
        if (!name.contains("'")) {
            return "['" + name + "']";
        }
        return "[\"" + name + "\"]";
    }

    public static boolean isEmpty(CharSequence cs) {
        return StringUtils.isNull(cs) || cs.length() == 0;
    }

    private static boolean isNull(CharSequence cs) {
        return cs == null;
    }

    public static boolean isBlank(CharSequence cs) {
        if (StringUtils.isEmpty(cs)) {
            return true;
        }
        for (int i = 0; i < cs.length(); ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !StringUtils.isBlank(cs);
    }

    @Nullable
    public static String chop(String str) {
        if (StringUtils.isNull(str)) {
            return null;
        }
        int strLen = str.length();
        if (strLen <= 1) {
            return EMPTY;
        }
        int lastIdx = strLen - 1;
        return str.substring(0, lastIdx);
    }

    public static String removeEndIgnoreCase(String str, String remove) {
        if (StringUtils.isEmpty(str) || StringUtils.isEmpty(remove)) {
            return str;
        }
        if (StringUtils.endsWithIgnoreCase(str, remove)) {
            return str.substring(0, str.length() - remove.length());
        }
        return str;
    }

    public static String prependIfMissing(String str, String prefix) {
        if (StringUtils.isNull(str) || StringUtils.isNull(prefix)) {
            return str;
        }
        if (!str.startsWith(prefix)) {
            return prefix + str;
        }
        return str;
    }

    @Nullable
    public static String appendIfMissing(String str, CharSequence suffix, CharSequence ... suffixes) {
        if (StringUtils.isNull(str) || StringUtils.isNull(suffix)) {
            return str;
        }
        if (str.endsWith(suffix.toString())) {
            return str;
        }
        if (suffixes != null) {
            for (CharSequence s : suffixes) {
                if (s == null || !str.endsWith(s.toString())) continue;
                return str;
            }
        }
        return str + suffix;
    }

    public static boolean endsWithIgnoreCase(CharSequence str, CharSequence suffix) {
        boolean isEitherNull;
        boolean areBothNull = StringUtils.isNull(str) && StringUtils.isNull(suffix);
        boolean bl = isEitherNull = StringUtils.isNull(str) || StringUtils.isNull(suffix);
        if (isEitherNull) {
            return areBothNull;
        }
        if (suffix.length() > str.length()) {
            return false;
        }
        return str.toString().regionMatches(true, str.length() - suffix.length(), suffix.toString(), 0, suffix.length());
    }

    @Nullable
    public static String unescapeJava(String str) {
        if (StringUtils.isEmpty(str) || str.isEmpty()) {
            return str;
        }
        StringBuilder result = new StringBuilder(str.length());
        int length = str.length();
        block16: for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch != '\\') {
                result.append(ch);
                continue;
            }
            if (i + 1 >= length) {
                result.append(ch);
                continue;
            }
            char nextChar = str.charAt(i + 1);
            switch (nextChar) {
                case '\\': {
                    result.append('\\');
                    ++i;
                    continue block16;
                }
                case '\"': {
                    result.append('\"');
                    ++i;
                    continue block16;
                }
                case '\'': {
                    result.append('\'');
                    ++i;
                    continue block16;
                }
                case 'n': {
                    result.append('\n');
                    ++i;
                    continue block16;
                }
                case 'r': {
                    result.append('\r');
                    ++i;
                    continue block16;
                }
                case 't': {
                    result.append('\t');
                    ++i;
                    continue block16;
                }
                case 'b': {
                    result.append('\b');
                    ++i;
                    continue block16;
                }
                case 'f': {
                    result.append('\f');
                    ++i;
                    continue block16;
                }
                case '/': {
                    result.append('/');
                    ++i;
                    continue block16;
                }
                case 'u': {
                    if (i + 5 < length) {
                        String unicode = str.substring(i + 2, i + 6);
                        try {
                            int unicodeValue = Integer.parseInt(unicode, 16);
                            result.append((char)unicodeValue);
                            i += 5;
                        }
                        catch (NumberFormatException e) {
                            result.append(ch);
                        }
                        continue block16;
                    }
                    result.append(ch);
                    continue block16;
                }
                default: {
                    if (nextChar >= '0' && nextChar <= '7') {
                        int j;
                        StringBuilder octal = new StringBuilder();
                        for (j = i + 1; j < length && j < i + 4 && str.charAt(j) >= '0' && str.charAt(j) <= '7'; ++j) {
                            octal.append(str.charAt(j));
                        }
                        try {
                            int octalValue = Integer.parseInt(octal.toString(), 8);
                            if (octalValue <= 255) {
                                result.append((char)octalValue);
                                i = j - 1;
                                continue block16;
                            }
                            result.append(ch);
                        }
                        catch (NumberFormatException e) {
                            result.append(ch);
                        }
                        continue block16;
                    }
                    result.append(ch);
                }
            }
        }
        return result.toString();
    }
}

