/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.http;

import com.azure.core.http.HttpClientProvider;
import com.azure.core.http.ProxyOptions;

public class HttpClientProperties {
    private final Integer maxIdleTime;
    private final boolean keepAlive;
    private final Integer maxConnectionTotal;
    private final Class<? extends HttpClientProvider> provider;
    private final ProxyOptions proxy;
    private final Integer readTimeout;

    private HttpClientProperties(HttpClientPropertiesBuilder builder) {
        this.maxIdleTime = builder.maxIdleTime;
        this.keepAlive = builder.keepAlive;
        this.maxConnectionTotal = builder.maxConnectionsTotal;
        this.provider = builder.provider;
        this.proxy = builder.proxy;
        this.readTimeout = builder.readTimeout;
    }

    public static HttpClientPropertiesBuilder builder() {
        return new HttpClientPropertiesBuilder();
    }

    public Integer maxIdleTime() {
        return this.maxIdleTime;
    }

    public Integer readTimeout() {
        return this.readTimeout;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public Integer maxConnectionTotal() {
        return this.maxConnectionTotal;
    }

    public Class<? extends HttpClientProvider> provider() {
        return this.provider;
    }

    public ProxyOptions getProxy() {
        return this.proxy;
    }

    public static class HttpClientPropertiesBuilder {
        private Integer maxIdleTime = 120;
        private boolean keepAlive;
        private Integer readTimeout = 3600;
        private Integer maxConnectionsTotal = 40;
        private Class<? extends HttpClientProvider> provider = null;
        private ProxyOptions proxy = null;

        public HttpClientPropertiesBuilder maxIdleTime(Integer maxIdleTime) {
            this.maxIdleTime = maxIdleTime;
            return this;
        }

        public HttpClientPropertiesBuilder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public HttpClientPropertiesBuilder readTimeout(Integer readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public HttpClientPropertiesBuilder maxConnectionsTotal(Integer maxConnectionsTotal) {
            this.maxConnectionsTotal = maxConnectionsTotal;
            return this;
        }

        public HttpClientPropertiesBuilder provider(Class<? extends HttpClientProvider> provider) {
            this.provider = provider;
            return this;
        }

        public HttpClientPropertiesBuilder proxy(ProxyOptions proxy) {
            this.proxy = proxy;
            return this;
        }

        public HttpClientProperties build() {
            return new HttpClientProperties(this);
        }
    }
}

