/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.kusto.data.auth;

import com.azure.core.http.HttpClient;
import com.microsoft.azure.kusto.data.auth.CloudInfo;
import com.microsoft.azure.kusto.data.auth.TokenProviderBase;
import com.microsoft.azure.kusto.data.exceptions.DataServiceException;
import com.microsoft.azure.kusto.data.instrumentation.MonitoredActivity;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import reactor.core.publisher.Mono;

public abstract class CloudDependentTokenProviderBase
extends TokenProviderBase {
    private static final String ERROR_INVALID_SERVICE_RESOURCE_URL = "Error determining scope due to invalid Kusto Service Resource URL";
    protected final Set<String> scopes = new HashSet<String>();
    private boolean initialized = false;
    private CloudInfo cloudInfo;

    CloudDependentTokenProviderBase(@NotNull String clusterUrl, @Nullable HttpClient httpClient) throws URISyntaxException {
        super(clusterUrl, httpClient);
    }

    @Override
    final Mono<Void> initialize() {
        return Mono.defer(() -> {
            if (this.initialized) {
                return Mono.empty();
            }
            return MonitoredActivity.wrap(CloudInfo.retrieveCloudInfoForClusterAsync(this.clusterUrl, this.httpClient), "CloudDependentTokenProviderBase.retrieveCloudInfo", this.getTracingAttributes()).doOnNext(cloudInfoResult -> {
                this.cloudInfo = cloudInfoResult;
                this.initializeWithCloudInfo((CloudInfo)cloudInfoResult);
                this.initialized = true;
            }).then();
        });
    }

    protected void initializeWithCloudInfo(CloudInfo cloudInfo) {
        try {
            this.scopes.add(cloudInfo.determineScope());
        }
        catch (URISyntaxException e) {
            throw new DataServiceException(this.clusterUrl, ERROR_INVALID_SERVICE_RESOURCE_URL, e, true);
        }
    }

    @Override
    public Map<String, String> getTracingAttributes() {
        Map<String, String> attributes = super.getTracingAttributes();
        if (this.cloudInfo != null) {
            attributes.putAll(this.cloudInfo.getTracingAttributes());
        }
        attributes.put("http.url", this.clusterUrl);
        return attributes;
    }
}

