/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.storage.models.Reason;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.Availability;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.AzureStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountModule;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class StorageServiceSubscription
extends AbstractAzServiceSubscription<StorageServiceSubscription, StorageManager> {
    @Nonnull
    private final String subscriptionId;
    @Nonnull
    private final StorageAccountModule storageModule;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    StorageServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureStorageAccount service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.storageModule = new StorageAccountModule(this);
    }

    StorageServiceSubscription(@Nonnull StorageManager remote, @Nonnull AzureStorageAccount service) {
        this(remote.subscriptionId(), service);
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.storageModule);
    }

    @Nonnull
    public StorageAccountModule storageAccounts() {
        return this.storageModule;
    }

    @Nonnull
    public List<Region> listSupportedRegions() {
        return super.listSupportedRegions(this.storageModule.getName());
    }

    @Nonnull
    public ResourceManager getResourceManager() {
        return Objects.requireNonNull((StorageManager)this.getRemote()).resourceManager();
    }

    @Nonnull
    @AzureOperation(name="azure/storage.check_name.name", params={"name"})
    public Availability checkNameAvailability(@Nonnull String name) {
        String string = name;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            CheckNameAvailabilityResult result = Objects.requireNonNull((StorageManager)this.getRemote()).storageAccounts().checkNameAvailability(name);
            Availability availability = new Availability(result.isAvailable(), (String)Optional.ofNullable(result.reason()).map(Reason::toString).orElse(null), result.message());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return availability;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    @Generated
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nonnull
    @Generated
    public StorageAccountModule getStorageModule() {
        return this.storageModule;
    }

    static {
        StorageServiceSubscription.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("StorageServiceSubscription.java", StorageServiceSubscription.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "checkNameAvailability", "com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription", "java.lang.String", "name", "", "com.microsoft.azure.toolkit.lib.common.model.Availability"), 67);
    }
}

