/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.azure.core.http.policy.FixedDelayOptions;
import com.azure.core.http.policy.RetryOptions;
import com.azure.core.util.logging.ClientLogger;
import com.azure.data.tables.TableServiceClient;
import com.azure.data.tables.TableServiceClientBuilder;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.BlobServiceClientBuilder;
import com.azure.storage.common.implementation.connectionstring.StorageConnectionString;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractConnectionStringAzResource;
import com.microsoft.azure.toolkit.lib.storage.ConnectionStringStorageAccountModule;
import com.microsoft.azure.toolkit.lib.storage.IStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainerModule;
import com.microsoft.azure.toolkit.lib.storage.queue.QueueModule;
import com.microsoft.azure.toolkit.lib.storage.share.ShareModule;
import com.microsoft.azure.toolkit.lib.storage.table.TableModule;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;

public class ConnectionStringStorageAccount
extends AbstractConnectionStringAzResource<ConnectionStringStorageAccount>
implements IStorageAccount {
    private static final ClientLogger LOGGER = new ClientLogger(ConnectionStringStorageAccount.class);
    private static final RetryOptions TEST_CONNECTION_RETRY_OPTIONS = new RetryOptions(new FixedDelayOptions(0, Duration.ofSeconds(3L)));
    protected final BlobContainerModule blobContainerModule;
    protected final ShareModule shareModule;
    protected final QueueModule queueModule;
    protected final TableModule tableModule;
    protected final List<AbstractAzResourceModule<?, ?, ?>> subModules = new ArrayList();
    private final StorageConnectionString settings;
    private boolean loaded = false;

    protected ConnectionStringStorageAccount(@Nonnull String connectionString) {
        super(connectionString, ConnectionStringStorageAccount.extractNameFromConnectionString(connectionString), (AbstractAzResourceModule)ConnectionStringStorageAccountModule.getInstance());
        this.settings = StorageConnectionString.create((String)connectionString, (ClientLogger)LOGGER);
        this.blobContainerModule = new BlobContainerModule(this);
        this.shareModule = new ShareModule(this);
        this.queueModule = new QueueModule(this);
        this.tableModule = new TableModule(this);
    }

    public void invalidateCache() {
        this.subModules.clear();
        super.invalidateCache();
    }

    @Override
    public String getKey() {
        return this.settings.getStorageAuthSettings().getAccount().getAccessKey();
    }

    protected synchronized void updateAdditionalProperties(@Nullable String newRemote, @Nullable String oldRemote) {
        this.subModules.clear();
        if (Objects.nonNull(newRemote)) {
            this.getSubModules();
        }
        super.updateAdditionalProperties((Object)newRemote, (Object)oldRemote);
    }

    public boolean exists() {
        return !this.loaded || !this.subModules.isEmpty();
    }

    @Nonnull
    public String getStatus() {
        return this.loadStatus(this.getConnectionString());
    }

    @Nonnull
    protected String loadStatus(@Nonnull String connectionString) {
        return CollectionUtils.isNotEmpty(this.subModules) ? "Running" : (this.loaded ? "Failed" : "Connecting");
    }

    @Nonnull
    public synchronized List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        this.setStatus("Connecting");
        if (!this.subModules.isEmpty()) {
            return this.subModules;
        }
        if (this.canHaveBlobs()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.blobContainerModule);
        }
        if (this.canHaveShares()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.shareModule);
        }
        if (this.canHaveQueues()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.queueModule);
        }
        if (this.canHaveTables()) {
            this.subModules.add((AbstractAzResourceModule<?, ?, ?>)this.tableModule);
        }
        this.loaded = true;
        this.setStatus(CollectionUtils.isNotEmpty(this.subModules) ? "Running" : "Failed");
        return this.subModules;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getCachedSubModules() {
        return this.subModules;
    }

    public boolean canHaveQueues() {
        try {
            QueueServiceClient client = new QueueServiceClientBuilder().retryOptions(TEST_CONNECTION_RETRY_OPTIONS).connectionString(this.getConnectionString()).buildClient();
            client.getProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canHaveTables() {
        try {
            TableServiceClient client = new TableServiceClientBuilder().retryOptions(TEST_CONNECTION_RETRY_OPTIONS).connectionString(this.getConnectionString()).buildClient();
            client.getProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canHaveBlobs() {
        try {
            BlobServiceClient client = new BlobServiceClientBuilder().retryOptions(TEST_CONNECTION_RETRY_OPTIONS).connectionString(this.getConnectionString()).buildClient();
            client.getProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean canHaveShares() {
        try {
            ShareServiceClient client = new ShareServiceClientBuilder().retryOptions(TEST_CONNECTION_RETRY_OPTIONS).connectionString(this.getConnectionString()).buildClient();
            client.getProperties();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String extractNameFromConnectionString(String connectionString) {
        StorageConnectionString storageConnectionString = StorageConnectionString.create((String)connectionString, (ClientLogger)LOGGER);
        return storageConnectionString.getAccountName();
    }

    @Override
    @Generated
    public BlobContainerModule getBlobContainerModule() {
        return this.blobContainerModule;
    }

    @Override
    @Generated
    public ShareModule getShareModule() {
        return this.shareModule;
    }

    @Override
    @Generated
    public QueueModule getQueueModule() {
        return this.queueModule;
    }

    @Override
    @Generated
    public TableModule getTableModule() {
        return this.tableModule;
    }
}

