/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.share;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.storage.file.share.ShareClient;
import com.azure.storage.file.share.ShareServiceClient;
import com.azure.storage.file.share.ShareServiceClientBuilder;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.common.model.AbstractEmulatableAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperation;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.storage.IStorageAccount;
import com.microsoft.azure.toolkit.lib.storage.share.Share;
import com.microsoft.azure.toolkit.lib.storage.share.ShareDraft;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class ShareModule
extends AbstractEmulatableAzResourceModule<Share, IStorageAccount, ShareClient> {
    public static final String NAME = "Azure.FileShare";
    private ShareServiceClient client;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public ShareModule(@Nonnull IStorageAccount parent) {
        super(NAME, (AzResource)parent);
    }

    protected void invalidateCache() {
        super.invalidateCache();
        this.client = null;
    }

    @Nullable
    synchronized ShareServiceClient getFileShareServiceClient() {
        if (Objects.isNull(this.client) && ((IStorageAccount)this.parent).exists()) {
            String connectionString = ((IStorageAccount)this.parent).getConnectionString();
            this.client = new ShareServiceClientBuilder().addPolicy(AbstractAzServiceSubscription.getUserAgentPolicy()).connectionString(connectionString).buildClient();
        }
        return this.client;
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, ShareClient>> loadResourcePagesFromAzure() {
        if (!((IStorageAccount)this.parent).exists()) {
            return Collections.emptyIterator();
        }
        ShareServiceClient client = this.getFileShareServiceClient();
        return Objects.requireNonNull(client).listShares().streamByPage(ShareModule.getPageSize()).map(p -> new ItemPage(p.getValue().stream().map(c -> client.getShareClient(c.getName())))).iterator();
    }

    @Nullable
    protected ShareClient loadResourceFromAzure(@Nonnull String name, @Nullable String resourceGroup) {
        if (!((IStorageAccount)this.parent).exists()) {
            return null;
        }
        ShareServiceClient client = this.getFileShareServiceClient();
        Stream<ShareClient> resources = Objects.requireNonNull(client).listShares().stream().map(s -> client.getShareClient(s.getName()));
        return resources.filter(c -> c.getShareName().equals(name)).findAny().orElse(null);
    }

    @AzureOperation(name="azure/storage.delete_share.share", params={"nameFromResourceId(resourceId)"})
    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        String string = resourceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string);
        try {
            AzureOperationAspect.aspectOf().beforeEnter(joinPoint);
            ResourceId id = ResourceId.fromString((String)resourceId);
            ShareServiceClient client = this.getFileShareServiceClient();
            Objects.requireNonNull(client).deleteShare(id.name());
            AzureOperationAspect.aspectOf().afterReturning(joinPoint);
            return;
        }
        catch (Throwable throwable) {
            AzureOperationAspect.aspectOf().afterThrowing(joinPoint, throwable);
            throw throwable;
        }
    }

    @Nonnull
    protected ShareDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ShareDraft(name, this);
    }

    @Nonnull
    protected Share newResource(@Nonnull ShareClient r) {
        return new Share(r.getShareName(), this);
    }

    @Nonnull
    protected Share newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Share(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "File Share";
    }

    static {
        ShareModule.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ShareModule.java", ShareModule.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "deleteResourceFromAzure", "com.microsoft.azure.toolkit.lib.storage.share.ShareModule", "java.lang.String", "resourceId", "", "void"), 76);
    }
}

