/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage;

import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.StorageAccounts;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.storage.StorageAccount;
import com.microsoft.azure.toolkit.lib.storage.StorageAccountDraft;
import com.microsoft.azure.toolkit.lib.storage.StorageServiceSubscription;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class StorageAccountModule
extends AbstractAzResourceModule<StorageAccount, StorageServiceSubscription, com.azure.resourcemanager.storage.models.StorageAccount> {
    public static final String NAME = "storageAccounts";

    public StorageAccountModule(@Nonnull StorageServiceSubscription parent) {
        super(NAME, (AzResource)parent);
    }

    @Nullable
    public StorageAccounts getClient() {
        return Optional.ofNullable(((StorageServiceSubscription)this.parent).getRemote()).map(StorageManager::storageAccounts).orElse(null);
    }

    @Nonnull
    protected StorageAccountDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        assert (resourceGroupName != null) : "'Resource group' is required.";
        return new StorageAccountDraft(name, resourceGroupName, this);
    }

    @Nonnull
    protected StorageAccountDraft newDraftForUpdate(@Nonnull StorageAccount origin) {
        return new StorageAccountDraft(origin);
    }

    @Nonnull
    protected StorageAccount newResource(@Nonnull com.azure.resourcemanager.storage.models.StorageAccount r) {
        return new StorageAccount(r, this);
    }

    @Nonnull
    protected StorageAccount newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new StorageAccount(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Azure Storage Account";
    }
}

