/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.storage.blob;

import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.sas.BlobContainerSasPermission;
import com.azure.storage.blob.sas.BlobSasPermission;
import com.azure.storage.blob.sas.BlobServiceSasSignatureValues;
import com.azure.storage.common.sas.SasProtocol;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.storage.blob.BlobContainer;
import com.microsoft.azure.toolkit.lib.storage.model.StorageFile;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

public interface IBlobFile
extends StorageFile {
    public static final Action.Id<IBlobFile> CREATE_BLOB = Action.Id.of((String)"user/storage.create_blob.blob");

    public BlobContainer getContainer();

    @Nullable
    public BlobContainerClient getClient();

    @Override
    default public String getSasUrl() {
        String token;
        BlobContainerClient client = this.getClient();
        if (Objects.isNull(client)) {
            throw new AzureToolkitRuntimeException(String.format("%s doesn't exist.", this.getName()));
        }
        OffsetDateTime expiration = OffsetDateTime.now().plusDays(1L);
        String containerUrl = this.getContainer().getUrl();
        if (this instanceof BlobContainer) {
            BlobContainerSasPermission containerPermission = new BlobContainerSasPermission().setReadPermission(true).setListPermission(true);
            BlobServiceSasSignatureValues builder = new BlobServiceSasSignatureValues(expiration, containerPermission).setProtocol(SasProtocol.HTTPS_ONLY);
            token = client.generateSas(builder);
        } else {
            BlobSasPermission blobPermission = new BlobSasPermission().setReadPermission(true).setListPermission(true);
            BlobServiceSasSignatureValues builder = new BlobServiceSasSignatureValues(expiration, blobPermission).setProtocol(SasProtocol.HTTPS_ONLY);
            token = client.generateSas(builder);
        }
        return String.format("%s/%s?%s", containerUrl, this.getPath(), token);
    }
}

