/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.AzureService;
import com.microsoft.azure.toolkit.lib.SubscriptionScoped;
import com.microsoft.azure.toolkit.lib.auth.Account;
import com.microsoft.azure.toolkit.lib.auth.AzureAccount;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.ResourceGroup;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import reactor.core.publisher.Flux;

public class AzureGroup
extends SubscriptionScoped<AzureGroup>
implements AzureService {
    public AzureGroup() {
        super(AzureGroup::new);
    }

    private AzureGroup(@Nonnull List<Subscription> subscriptions) {
        super(AzureGroup::new, subscriptions);
    }

    public List<ResourceGroup> list() {
        return (List)Flux.fromIterable((Iterable)this.getSubscriptions()).parallel().map(subscription -> this.getResourceManager(subscription.getId())).flatMap(azureResourceManager -> azureResourceManager.resourceGroups().listAsync()).map(AzureGroup::fromResource).sequential().collectList().block();
    }

    public List<ResourceGroup> list(String subscriptionId) {
        return (List)this.getResourceManager(subscriptionId).resourceGroups().listAsync().map(AzureGroup::fromResource).collect(Collectors.toList()).block();
    }

    public ResourceGroup getById(@Nonnull String idStr) {
        ResourceId id = ResourceId.fromString((String)idStr);
        return this.get(id.subscriptionId(), id.resourceGroupName());
    }

    public ResourceGroup getByName(@Nonnull String name) {
        return this.get(this.getDefaultSubscription().getId(), name);
    }

    public ResourceGroup get(@Nonnull String subscriptionId, @Nonnull String name) {
        return AzureGroup.fromResource((com.azure.resourcemanager.resources.models.ResourceGroup)this.getResourceManager(subscriptionId).resourceGroups().getByName(name));
    }

    public ResourceGroup create(String name, String region) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name, region})) {
            com.azure.resourcemanager.resources.models.ResourceGroup result = (com.azure.resourcemanager.resources.models.ResourceGroup)((ResourceGroup.DefinitionStages.WithCreate)((ResourceGroup.DefinitionStages.Blank)this.getResourceManager(this.getDefaultSubscription().getId()).resourceGroups().define(name)).withRegion(region)).create();
            return AzureGroup.fromResource(result);
        }
        throw new AzureToolkitRuntimeException("Please provide both name and region to create a resource group.");
    }

    public void delete(String name) {
        this.delete(this.getDefaultSubscription().getId(), name);
    }

    public void delete(String subscriptionId, String name) {
        this.getResourceManager(subscriptionId).resourceGroups().deleteByName(name);
    }

    private static ResourceGroup fromResource(@Nonnull com.azure.resourcemanager.resources.models.ResourceGroup resource) {
        ResourceId resourceId = ResourceId.fromString((String)resource.id());
        String subscriptionId = resourceId.subscriptionId();
        String name = resource.name();
        String region = resource.regionName();
        String id = resource.id();
        return ResourceGroup.builder().subscriptionId(subscriptionId).id(id).name(name).region(region).build();
    }

    @Cacheable(cacheName="ResourceManager", key="$subscriptionId")
    private ResourceManager getResourceManager(String subscriptionId) {
        Account account = ((AzureAccount)Azure.az(AzureAccount.class)).account();
        AzureConfiguration config = Azure.az().config();
        String userAgent = config.getUserAgent();
        HttpLogDetailLevel logDetailLevel = config.getLogLevel() == null ? HttpLogDetailLevel.NONE : HttpLogDetailLevel.valueOf((String)config.getLogLevel());
        AzureProfile azureProfile = new AzureProfile(account.getEnvironment());
        return ((ResourceManager.Configurable)((ResourceManager.Configurable)ResourceManager.configure().withLogLevel(logDetailLevel)).withPolicy(this.getUserAgentPolicy(userAgent))).authenticate(account.getTokenCredential(subscriptionId), azureProfile).withSubscription(subscriptionId);
    }

    private HttpPipelinePolicy getUserAgentPolicy(String userAgent) {
        return (httpPipelineCallContext, httpPipelineNextPolicy) -> {
            String previousUserAgent = httpPipelineCallContext.getHttpRequest().getHeaders().getValue("User-Agent");
            httpPipelineCallContext.getHttpRequest().setHeader("User-Agent", String.format("%s %s", userAgent, previousUserAgent));
            return httpPipelineNextPolicy.process();
        };
    }
}

