/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.monitor;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.common.model.Region;
import com.microsoft.azure.toolkit.lib.common.model.Subscription;
import com.microsoft.azure.toolkit.lib.monitor.AzureLogAnalyticsWorkspace;
import com.microsoft.azure.toolkit.lib.monitor.LogAnalyticsWorkspace;
import java.util.Objects;
import java.util.Optional;

public class LogAnalyticsWorkspaceConfig {
    private boolean newCreate;
    private String name;
    private String resourceId;
    private String subscriptionId;
    private String regionName;

    public static LogAnalyticsWorkspaceConfig createConfig(Subscription subscription, Region region) {
        String defaultWorkspaceName = String.format("DefaultWorkspace-%s-%s", subscription.getId(), Optional.ofNullable(region).map(Region::getAbbreviation).orElse(""));
        String finalWorkspaceName = defaultWorkspaceName.length() > 63 ? defaultWorkspaceName.substring(0, 63) : defaultWorkspaceName;
        Optional<LogAnalyticsWorkspace> remoteWorkspace = ((AzureLogAnalyticsWorkspace)Azure.az(AzureLogAnalyticsWorkspace.class)).logAnalyticsWorkspaces(subscription.getId()).list().stream().filter(workspace -> Objects.equals(workspace.getName(), finalWorkspaceName)).findFirst();
        Object workspaceConfig = ((LogAnalyticsWorkspaceConfigBuilder)((LogAnalyticsWorkspaceConfigBuilder)((LogAnalyticsWorkspaceConfigBuilder)((LogAnalyticsWorkspaceConfigBuilder)LogAnalyticsWorkspaceConfig.builder().newCreate(!remoteWorkspace.isPresent())).subscriptionId(subscription.getId())).name(finalWorkspaceName)).regionName(Optional.ofNullable(region).map(Region::getName).orElse(""))).build();
        remoteWorkspace.ifPresent(w -> workspaceConfig.setResourceId(w.getId()));
        return workspaceConfig;
    }

    protected LogAnalyticsWorkspaceConfig(LogAnalyticsWorkspaceConfigBuilder<?, ?> b) {
        this.newCreate = ((LogAnalyticsWorkspaceConfigBuilder)b).newCreate;
        this.name = ((LogAnalyticsWorkspaceConfigBuilder)b).name;
        this.resourceId = ((LogAnalyticsWorkspaceConfigBuilder)b).resourceId;
        this.subscriptionId = ((LogAnalyticsWorkspaceConfigBuilder)b).subscriptionId;
        this.regionName = ((LogAnalyticsWorkspaceConfigBuilder)b).regionName;
    }

    public static LogAnalyticsWorkspaceConfigBuilder<?, ?> builder() {
        return new LogAnalyticsWorkspaceConfigBuilderImpl();
    }

    public boolean isNewCreate() {
        return this.newCreate;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setNewCreate(boolean newCreate) {
        this.newCreate = newCreate;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResourceId(String resourceId) {
        this.resourceId = resourceId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LogAnalyticsWorkspaceConfig)) {
            return false;
        }
        LogAnalyticsWorkspaceConfig other = (LogAnalyticsWorkspaceConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$resourceId = this.getResourceId();
        String other$resourceId = other.getResourceId();
        return !(this$resourceId == null ? other$resourceId != null : !this$resourceId.equals(other$resourceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LogAnalyticsWorkspaceConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $resourceId = this.getResourceId();
        result = result * 59 + ($resourceId == null ? 43 : $resourceId.hashCode());
        return result;
    }

    public LogAnalyticsWorkspaceConfig() {
    }

    public LogAnalyticsWorkspaceConfig(boolean newCreate, String name, String resourceId, String subscriptionId, String regionName) {
        this.newCreate = newCreate;
        this.name = name;
        this.resourceId = resourceId;
        this.subscriptionId = subscriptionId;
        this.regionName = regionName;
    }

    private static final class LogAnalyticsWorkspaceConfigBuilderImpl
    extends LogAnalyticsWorkspaceConfigBuilder<LogAnalyticsWorkspaceConfig, LogAnalyticsWorkspaceConfigBuilderImpl> {
        private LogAnalyticsWorkspaceConfigBuilderImpl() {
        }

        @Override
        protected LogAnalyticsWorkspaceConfigBuilderImpl self() {
            return this;
        }

        @Override
        public LogAnalyticsWorkspaceConfig build() {
            return new LogAnalyticsWorkspaceConfig(this);
        }
    }

    public static abstract class LogAnalyticsWorkspaceConfigBuilder<C extends LogAnalyticsWorkspaceConfig, B extends LogAnalyticsWorkspaceConfigBuilder<C, B>> {
        private boolean newCreate;
        private String name;
        private String resourceId;
        private String subscriptionId;
        private String regionName;

        protected abstract B self();

        public abstract C build();

        public B newCreate(boolean newCreate) {
            this.newCreate = newCreate;
            return this.self();
        }

        public B name(String name) {
            this.name = name;
            return this.self();
        }

        public B resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this.self();
        }

        public B subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this.self();
        }

        public B regionName(String regionName) {
            this.regionName = regionName;
            return this.self();
        }

        public String toString() {
            return "LogAnalyticsWorkspaceConfig.LogAnalyticsWorkspaceConfigBuilder(newCreate=" + this.newCreate + ", name=" + this.name + ", resourceId=" + this.resourceId + ", subscriptionId=" + this.subscriptionId + ", regionName=" + this.regionName + ")";
        }
    }
}

