/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.resourcemanager.containerregistry.ContainerRegistryManager;
import com.azure.resourcemanager.containerregistry.fluent.ContainerRegistryManagementClient;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzServiceSubscription;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistry;
import com.microsoft.azure.toolkit.lib.containerregistry.AzureContainerRegistryModule;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class AzureContainerRegistryServiceSubscription
extends AbstractAzServiceSubscription<AzureContainerRegistryServiceSubscription, ContainerRegistryManager> {
    @Nonnull
    private final String subscriptionId;
    private final AzureContainerRegistryModule azureContainerRegistryModule;

    protected AzureContainerRegistryServiceSubscription(@Nonnull String subscriptionId, @Nonnull AzureContainerRegistry service) {
        super(subscriptionId, (AbstractAzResourceModule)service);
        this.subscriptionId = subscriptionId;
        this.azureContainerRegistryModule = new AzureContainerRegistryModule(this);
    }

    protected AzureContainerRegistryServiceSubscription(@Nonnull ContainerRegistryManager manager, AzureContainerRegistry service) {
        this(((ContainerRegistryManagementClient)manager.serviceClient()).getSubscriptionId(), service);
    }

    public AzureContainerRegistryModule registry() {
        return this.azureContainerRegistryModule;
    }

    @Nonnull
    public List<AbstractAzResourceModule<?, ?, ?>> getSubModules() {
        return Collections.singletonList(this.azureContainerRegistryModule);
    }

    @Nonnull
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public AzureContainerRegistryModule getAzureContainerRegistryModule() {
        return this.azureContainerRegistryModule;
    }
}

