/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.containerregistry;

import com.azure.containers.containerregistry.ContainerRepository;
import com.azure.containers.containerregistry.RegistryArtifact;
import com.azure.containers.containerregistry.models.ArtifactManifestProperties;
import com.azure.core.util.paging.ContinuablePage;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.containerregistry.Artifact;
import com.microsoft.azure.toolkit.lib.containerregistry.Repository;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ArtifactModule
extends AbstractAzResourceModule<Artifact, Repository, ArtifactManifestProperties> {
    public static final String NAME = "artifacts";

    public ArtifactModule(@Nonnull Repository parent) {
        super(NAME, (AzResource)parent);
    }

    @Nonnull
    protected Iterator<? extends ContinuablePage<String, ArtifactManifestProperties>> loadResourcePagesFromAzure() {
        if (!((Repository)this.parent).exists()) {
            return Collections.emptyIterator();
        }
        return Optional.ofNullable(((Repository)this.parent).getRemote()).map(r -> r.listManifestProperties().streamByPage(ArtifactModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Nullable
    protected ArtifactManifestProperties loadResourceFromAzure(@Nonnull String name, String unused) {
        if (!((Repository)this.parent).exists()) {
            return null;
        }
        ContainerRepository remote = (ContainerRepository)Objects.requireNonNull(((Repository)this.parent).getRemote());
        return remote.listManifestProperties().stream().filter(p -> p.getDigest().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    protected void deleteResourceFromAzure(@Nonnull String resourceId) {
        Optional.ofNullable(this.get(resourceId)).map(Artifact::getArtifact).ifPresent(RegistryArtifact::delete);
    }

    @Nonnull
    protected Artifact newResource(@Nonnull ArtifactManifestProperties manifest) {
        return new Artifact(manifest.getDigest(), this);
    }

    @Nonnull
    protected Artifact newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new Artifact(name, this);
    }

    @Nonnull
    public String getResourceTypeName() {
        return "Artifact";
    }
}

