/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.validator;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.networknt.schema.ValidatorTypeCode;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class ValidationMessage {
    private String type;
    private String code;
    private String path;
    private String[] arguments;
    private AzureString message;

    static ValidationMessage fromRawMessage(com.networknt.schema.ValidationMessage validationMessage) {
        return ValidationMessage.builder().type(validationMessage.getType()).code(validationMessage.getCode()).path(validationMessage.getPath()).arguments(validationMessage.getArguments()).message(ValidationMessage.getMessage(validationMessage)).build();
    }

    private static AzureString getMessage(com.networknt.schema.ValidationMessage validationMessage) {
        ValidatorTypeCode validatorTypeCode = Arrays.stream(ValidatorTypeCode.values()).filter(typeCode -> StringUtils.equalsIgnoreCase((CharSequence)validationMessage.getCode(), (CharSequence)typeCode.getErrorCode())).findFirst().orElse(null);
        if (validatorTypeCode == null) {
            return AzureString.fromString(validationMessage.getMessage());
        }
        Object[] path = new String[]{validationMessage.getPath()};
        Object[] args = ArrayUtils.isEmpty((Object[])validationMessage.getArguments()) ? path : (String[])ArrayUtils.addAll((Object[])path, (Object[])validationMessage.getArguments());
        return AzureString.format(validatorTypeCode.getMessageFormat().toPattern(), args);
    }

    @Generated
    ValidationMessage(String type, String code, String path, String[] arguments, AzureString message) {
        this.type = type;
        this.code = code;
        this.path = path;
        this.arguments = arguments;
        this.message = message;
    }

    @Generated
    public static ValidationMessageBuilder builder() {
        return new ValidationMessageBuilder();
    }

    @Generated
    public ValidationMessageBuilder toBuilder() {
        return new ValidationMessageBuilder().type(this.type).code(this.code).path(this.path).arguments(this.arguments).message(this.message);
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getCode() {
        return this.code;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String[] getArguments() {
        return this.arguments;
    }

    @Generated
    public AzureString getMessage() {
        return this.message;
    }

    @Generated
    public static class ValidationMessageBuilder {
        @Generated
        private String type;
        @Generated
        private String code;
        @Generated
        private String path;
        @Generated
        private String[] arguments;
        @Generated
        private AzureString message;

        @Generated
        ValidationMessageBuilder() {
        }

        @Generated
        public ValidationMessageBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public ValidationMessageBuilder code(String code) {
            this.code = code;
            return this;
        }

        @Generated
        public ValidationMessageBuilder path(String path) {
            this.path = path;
            return this;
        }

        @Generated
        public ValidationMessageBuilder arguments(String[] arguments) {
            this.arguments = arguments;
            return this;
        }

        @Generated
        public ValidationMessageBuilder message(AzureString message) {
            this.message = message;
            return this;
        }

        @Generated
        public ValidationMessage build() {
            return new ValidationMessage(this.type, this.code, this.path, this.arguments, this.message);
        }

        @Generated
        public String toString() {
            return "ValidationMessage.ValidationMessageBuilder(type=" + this.type + ", code=" + this.code + ", path=" + this.path + ", arguments=" + Arrays.deepToString(this.arguments) + ", message=" + this.message + ")";
        }
    }
}

