/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.common.model.AbstractConnectionStringAzResource;
import com.microsoft.azure.toolkit.lib.common.model.AzResource;
import com.microsoft.azure.toolkit.lib.common.model.page.ItemPage;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractConnectionStringAzResourceModule<T>
extends AbstractAzResourceModule<AbstractConnectionStringAzResource<T>, AzResource.None, String> {
    public static String CONNECTION_STRING_SUBSCRIPTION_ID = "<ConnectionStringResourcesSubscription>";
    public static String CONNECTION_STRING_RESOURCE_GROUP = "<ConnectionStringResourcesGroup>";

    public AbstractConnectionStringAzResourceModule(@NotNull String name, AzResource.None parent) {
        super(name, parent);
    }

    @Nonnull
    public AbstractConnectionStringAzResource<T> getOrInit(@Nonnull String connectionString) {
        return this.listCachedResources().stream().filter(r -> StringUtils.equalsIgnoreCase((CharSequence)connectionString, (CharSequence)r.getConnectionString())).findFirst().orElseGet(() -> {
            AbstractConnectionStringAzResource resource = (AbstractConnectionStringAzResource)this.newResource(connectionString);
            this.addResourceToLocal(resource.getId(), resource, new boolean[0]);
            return resource;
        });
    }

    @Override
    @Nonnull
    protected Iterator<? extends ContinuablePage<String, String>> loadResourcePagesFromAzure() {
        List strings = this.resources.values().stream().filter(Optional::isPresent).map(Optional::get).map(AbstractConnectionStringAzResource::getConnectionString).filter(StringUtils::isNotBlank).collect(Collectors.toList());
        return Collections.singletonList(new ItemPage(strings)).iterator();
    }

    @Override
    @Nonnull
    public String getFullResourceType() {
        return ResourceId.fromString((String)this.toResourceId("_FAKE_", CONNECTION_STRING_RESOURCE_GROUP)).fullResourceType();
    }

    @Override
    @Nonnull
    public String getSubscriptionId() {
        return CONNECTION_STRING_SUBSCRIPTION_ID;
    }

    @Override
    @Nonnull
    protected AbstractConnectionStringAzResource<T> newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        throw new AzureToolkitRuntimeException("create `ConnectionStringStorageAccount` from `name` and `resourceGroupName` is not supported.");
    }
}

