/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessagerProvider;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessager;
import com.microsoft.azure.toolkit.lib.common.operation.OperationContext;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureMessager {
    public static void setDefaultMessager(@Nonnull IAzureMessager defaultMessager) {
        Holder.defaultMessager = defaultMessager;
    }

    @Nonnull
    public static synchronized IAzureMessager getDefaultMessager() {
        if (Holder.defaultMessager == null) {
            Holder.defaultMessager = Holder.loadMessager();
        }
        return Holder.defaultMessager;
    }

    @Nonnull
    public static IAzureMessager getMessager() {
        return OperationContext.current().getMessager();
    }

    public static class DummyMessager
    implements IAzureMessager {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(DummyMessager.class);

        @Override
        public boolean show(IAzureMessage message) {
            log.info(message.getContent());
            return false;
        }
    }

    private static final class Holder {
        private static IAzureMessager defaultMessager = null;

        private Holder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public static IAzureMessager loadMessager() {
            ClassLoader current = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(AzureMessager.class.getClassLoader());
                ServiceLoader<AzureMessagerProvider> loader = ServiceLoader.load(AzureMessagerProvider.class, AzureMessager.class.getClassLoader());
                Iterator<AzureMessagerProvider> iterator = loader.iterator();
                if (iterator.hasNext()) {
                    IAzureMessager iAzureMessager = iterator.next().getMessager();
                    return iAzureMessager;
                }
                DummyMessager dummyMessager = new DummyMessager();
                return dummyMessager;
            }
            finally {
                Thread.currentThread().setContextClassLoader(current);
            }
        }
    }
}

