/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessage;
import com.microsoft.azure.toolkit.lib.common.messager.IAzureMessage;
import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureHtmlMessage
extends AzureMessage {
    static final Pattern URL_PATTERN = Pattern.compile("https?://(www\\.)?[-a-zA-Z0-9@:%._+~#=]{1,256}\\.[a-zA-Z0-9()]{1,6}\\b([-a-zA-Z0-9()@:%_+.~#?&/=]*)");
    static final Pattern HREF_PATTERN = Pattern.compile("<a href=(.*)>(.*)</a>");
    private IAzureMessage rawMessage;

    public AzureHtmlMessage(@Nonnull IAzureMessage.Type type, @Nonnull AzureString message) {
        super(type, message);
    }

    public AzureHtmlMessage(IAzureMessage origin) {
        super(origin.getType(), origin.getMessage());
        this.rawMessage = origin.getRawMessage();
        if (origin instanceof AzureMessage) {
            this.setValueDecorator(((AzureMessage)origin).getValueDecorator());
        }
        this.setTitle(origin.getTitle());
        this.setPayload(origin.getPayload());
        this.setActions(origin.getActions());
    }

    @Override
    @Nonnull
    public String getContent() {
        return AzureHtmlMessage.transformURLIntoLinks(super.getContent());
    }

    @Override
    @Nullable
    protected String getCause(@Nonnull Throwable throwable) {
        String color = this.getErrorColor();
        return Optional.ofNullable(super.getCause(throwable)).map(cause -> String.format("<span style=\"color: %s;\">%s</span>", color, cause)).orElse(null);
    }

    @Override
    protected String getDetailItem(Operation o) {
        return String.format("<li>%s</li>", super.getDetailItem(o));
    }

    @Override
    public String decorateValue(@Nonnull Object p, @Nullable Supplier<String> dft) {
        String result = super.decorateValue(p, null);
        if (Objects.isNull(result)) {
            String color = this.getValueColor();
            String font = "'JetBrains Mono', Consolas, 'Liberation Mono', Menlo, Courier, monospace";
            result = String.format("<span style=\"color: %s;font-family: %s;\">%s</span>", color, "'JetBrains Mono', Consolas, 'Liberation Mono', Menlo, Courier, monospace", p);
        }
        return Objects.isNull(result) && Objects.nonNull(dft) ? dft.get() : result;
    }

    @Override
    public IAzureMessage getRawMessage() {
        return Optional.ofNullable(this.rawMessage).orElse(this);
    }

    private static String transformURLIntoLinks(String text) {
        String[] nonHrefLinks = HREF_PATTERN.split(text);
        Matcher hrefMatcher = HREF_PATTERN.matcher(text);
        ArrayList<String> hrefLinks = new ArrayList<String>();
        while (hrefMatcher.find()) {
            hrefLinks.add(hrefMatcher.group());
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nonHrefLinks.length; ++i) {
            Matcher m = URL_PATTERN.matcher(nonHrefLinks[i]);
            while (m.find()) {
                String found = m.group(0);
                m.appendReplacement(sb, "<a href='" + found + "'>" + found + "</a>");
            }
            m.appendTail(sb);
            if (i >= hrefLinks.size()) continue;
            sb.append((String)hrefLinks.get(i));
        }
        return sb.toString();
    }

    protected String getErrorColor() {
        return "#FF0000";
    }

    protected String getValueColor() {
        return "#0000FF";
    }
}

