/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.cache;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import lombok.Generated;

public class LRUStack<T> {
    private final int size;
    private final Map<T, T> data = Collections.synchronizedMap(new LinkedHashMap<T, T>(5, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<T, T> eldest) {
            return this.size() > LRUStack.this.size;
        }
    });

    public LRUStack() {
        this.size = 5;
    }

    public T peek(Predicate<T> condition) {
        return Lists.reverse(new LinkedList<T>(this.data.values())).stream().filter(condition).findFirst().orElse(null);
    }

    public T peek() {
        if (this.data.isEmpty()) {
            return null;
        }
        return new LinkedList<T>(this.data.values()).getLast();
    }

    public void push(T v) {
        T t = this.data.get(v);
        if (Objects.isNull(t)) {
            this.data.put(v, v);
        }
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public Map<T, T> getData() {
        return this.data;
    }

    @Generated
    public LRUStack(int size) {
        this.size = size;
    }
}

