/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.microsoft.azure.toolkit.lib.common.cache.CacheEvict;
import com.microsoft.azure.toolkit.lib.common.cache.Cacheable;
import com.microsoft.azure.toolkit.lib.common.cache.LRUStack;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.ExpressionUtils;
import com.microsoft.azure.toolkit.lib.common.utils.aspect.MethodInvocation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class CacheManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CacheManager.class);
    private static final CacheLoader<String, Cache<Object, Object>> loader = new CacheLoader<String, Cache<Object, Object>>(){

        @Nonnull
        public Cache<Object, Object> load(@Nonnull String key) {
            return CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.HOURS).build();
        }
    };
    private static final LoadingCache<String, Cache<Object, Object>> caches = CacheBuilder.newBuilder().expireAfterAccess(4L, TimeUnit.HOURS).build(loader);
    private static final Map<Class<?>, Object> histories = new ConcurrentHashMap();
    private static final Map<String, Object> namedHistories = new ConcurrentHashMap<String, Object>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ CacheManager ajc$perSingletonInstance;

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.cache.Cacheable * *..*.*(..))")
    public void cacheable() {
    }

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.cache.CacheEvict * *..*.*(..))")
    public void cacheEvict() {
    }

    @Around(value="cacheable()")
    public Object aroundCacheable(@Nonnull ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        MethodInvocation invocation = MethodInvocation.from((JoinPoint)point);
        Cacheable annotation = signature.getMethod().getAnnotation(Cacheable.class);
        String cacheName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.cacheName(), annotation.value()});
        String name = ExpressionUtils.render(cacheName, invocation);
        String key = ExpressionUtils.render(annotation.key(), invocation);
        if (Objects.isNull(name) || Objects.isNull(key)) {
            CacheManager.log.warn(String.format("invalid @Cacheable on method(%s)", signature.getName()));
            return point.proceed();
        }
        String condition = annotation.condition();
        boolean toUseCache = StringUtils.isBlank((CharSequence)condition) || ExpressionUtils.evaluate(condition, invocation, true);
        Cache cache = (Cache)CacheManager.caches.get((Object)name);
        if (toUseCache) {
            CacheManager.log.debug(String.format("loading data from cache[%s.%s] on method[%s]", name, key, signature.getName()));
            return this.readCache((Cache<Object, Object>)cache, key, point);
        }
        CacheManager.log.debug(String.format("skipping cache[%s.%s] on method[%s]", name, key, signature.getName()));
        Object result = point.proceed();
        if (Objects.nonNull(result)) {
            cache.put((Object)key, Optional.of(result));
        }
        return result;
    }

    @Around(value="cacheEvict()")
    public Object aroundCacheEvict(@Nonnull ProceedingJoinPoint point) throws Throwable {
        boolean toEvictCache;
        MethodSignature signature = (MethodSignature)point.getSignature();
        MethodInvocation invocation = MethodInvocation.from((JoinPoint)point);
        CacheEvict annotation = signature.getMethod().getAnnotation(CacheEvict.class);
        String cacheName = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{annotation.cacheName(), annotation.value()});
        String name = ExpressionUtils.render(cacheName, invocation);
        String key = ExpressionUtils.render(annotation.key(), invocation);
        String condition = annotation.condition();
        boolean bl = toEvictCache = StringUtils.isBlank((CharSequence)condition) || ExpressionUtils.evaluate(condition, invocation, true);
        if (toEvictCache) {
            CacheManager.log.debug(String.format("evict cache[%s.%s] on method[%s]", name, key, signature.getName()));
            CacheManager.evictCache(name, key);
        }
        return point.proceed();
    }

    public static void evictCache(@Nullable String name, @Nullable String key) throws ExecutionException {
        if (StringUtils.isBlank((CharSequence)name)) {
            log.warn("cache name is not specified when invalidating cache");
        } else if (StringUtils.equals((CharSequence)"<ALL>", (CharSequence)name)) {
            log.debug("invalidate all caches");
            caches.invalidateAll();
        } else if (StringUtils.isBlank((CharSequence)key)) {
            log.warn(String.format("key is not specified when invalidating cache[%s]", name));
        } else if (StringUtils.equals((CharSequence)"<ALL>", (CharSequence)key)) {
            log.debug(String.format("invalidate all entries in cache[%s]", name));
            caches.invalidate((Object)name);
        } else {
            log.debug(String.format("invalidate cache entry[%s.%s]", name, key));
            ((Cache)caches.get((Object)name)).invalidate((Object)key);
        }
    }

    private Object readCache(Cache<Object, Object> cache, String key, ProceedingJoinPoint point) throws Throwable {
        Optional result = (Optional)cache.get((Object)key, () -> {
            try {
                log.debug(String.format("cache[%s] miss on method[%s]", key, point.getSignature().getName()));
                return Optional.ofNullable(point.proceed());
            }
            catch (Throwable throwable) {
                log.debug(String.format("error occurs on loading data into cache[%s] on method[%s]", key, point.getSignature().getName()), throwable);
                return Optional.of(throwable);
            }
        });
        if (result.isPresent() && result.get() instanceof Throwable) {
            cache.invalidate((Object)key);
            throw (Throwable)result.get();
        }
        return result.orElse(null);
    }

    public static <T> LRUStack<T> getUsageHistory(Class<T> clazz) {
        if (histories.containsKey(clazz)) {
            return (LRUStack)histories.get(clazz);
        }
        Optional<Map.Entry> found = histories.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(clazz) || clazz.isAssignableFrom((Class)e.getKey())).findFirst();
        if (found.isPresent()) {
            return (LRUStack)found.get().getValue();
        }
        return (LRUStack)histories.computeIfAbsent(clazz, c -> new LRUStack());
    }

    public static <T> LRUStack<T> getUsageHistory(String name) {
        return (LRUStack)namedHistories.computeIfAbsent(name, n -> new LRUStack());
    }

    static {
        try {
            CacheManager.ajc$perSingletonInstance = new CacheManager();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static CacheManager aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.cache.CacheManager", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

