/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.google.common.util.concurrent.SettableFuture;
import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.account.IAzureAccount;
import com.microsoft.azure.toolkit.lib.common.action.Action;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.AzureOperationAspect;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBundle;
import com.microsoft.azure.toolkit.lib.common.task.AzureTaskManager;
import com.microsoft.azure.toolkit.lib.common.view.IView;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionInstance<D>
extends OperationBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ActionInstance.class);
    public final Action<D> action;
    @Nullable
    private final D target;
    @Nullable
    private final Object event;
    private Function<D, String> iconProvider;
    private Function<D, String> labelProvider;
    private Function<D, AzureString> titleProvider;
    private Predicate<D> authRequiredProvider;
    private final List<Function<D, String>> titleParamProviders = new ArrayList<Function<D, String>>();

    public ActionInstance(@Nonnull Action<D> action, @Nullable D target, @Nullable Object event) {
        this.action = action;
        this.target = target;
        this.event = event;
    }

    @Override
    @Nonnull
    public String getId() {
        return this.action.getId().getId();
    }

    public String getPlace() {
        return AzureActionManager.getInstance().getPlace(this);
    }

    @Override
    public Callable<?> getBody() {
        return () -> {
            BiConsumer<D, Object> handler = this.action.getHandler(this.target, this.event);
            Optional.ofNullable(handler).ifPresent(h -> h.accept(this.target, this.event));
            return null;
        };
    }

    public boolean isPerformable() {
        return Objects.nonNull(this.action.getHandler(this.target, this.event));
    }

    @Override
    @Nullable
    public Object getSource() {
        return Optional.ofNullable(this.action.sourceProvider).map(p -> p.apply(this.target)).orElse(this.target);
    }

    @Override
    @Nullable
    public AzureString getDescription() {
        Function titleProvider = Optional.ofNullable(this.titleProvider).orElse(this.action.titleProvider);
        List titleParamProviders = Optional.of(this.titleParamProviders).filter(CollectionUtils::isNotEmpty).orElse(this.action.titleParamProviders);
        if (Objects.nonNull(titleProvider)) {
            return titleProvider.apply(this.target);
        }
        if (!titleParamProviders.isEmpty()) {
            Object[] params = titleParamProviders.stream().map(p -> (String)p.apply(this.target)).toArray();
            return OperationBundle.description(this.action.getId().getId(), params);
        }
        return OperationBundle.description(this.action.getId().getId(), new Object[0]);
    }

    @Nonnull
    public IView.Label getView() {
        return this.getView(this.getPlace());
    }

    @Nonnull
    public IView.Label getView(String place) {
        try {
            Predicate enableWhen = this.action.enableWhen;
            BiPredicate<Object, String> visibleWhen = this.action.visibleWhen;
            Function labelProvider = Optional.ofNullable(this.labelProvider).orElse(this.action.labelProvider);
            Function iconProvider = Optional.ofNullable(this.iconProvider).orElse(this.action.iconProvider);
            boolean visible = visibleWhen.test(this.target, place);
            if (visible) {
                String label = labelProvider.apply(this.target);
                String icon = Optional.ofNullable(iconProvider).map(p -> (String)p.apply(this.target)).orElse(null);
                boolean enabled = enableWhen.test(this.target) && this.isPerformable();
                AzureString title = this.getDescription();
                return new Action.View(label, icon, enabled, title);
            }
            return Action.View.INVISIBLE;
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
            return Action.View.INVISIBLE;
        }
    }

    private boolean isAuthRequired() {
        Predicate authRequiredProvider = Optional.ofNullable(this.authRequiredProvider).orElse(this.action.authRequiredProvider);
        return Optional.ofNullable(authRequiredProvider).map(p -> p.test(this.target)).orElse(true);
    }

    public void perform() {
        if (this.isAuthRequired() && !Azure.az(IAzureAccount.class).isLoggedIn()) {
            SettableFuture authorized = SettableFuture.create();
            this.getContext().setTelemetryProperty("action_place", this.getPlace());
            Action<Consumer<IAccount>> authorizeAction = AzureActionManager.getInstance().getAction(Action.REQUIRE_AUTH);
            authorizeAction.handleSync(arg_0 -> ((SettableFuture)authorized).set(arg_0), this.event);
            if (Objects.isNull(authorized.get())) {
                Azure.az(IAzureAccount.class).account();
            }
        }
        AzureOperationAspect.execute(this);
    }

    public void performAsync() {
        AzureTaskManager.getInstance().runInBackground(this.getDescription(), this::perform);
    }

    public ActionInstance<D> withLabel(@Nonnull String label) {
        this.labelProvider = any -> label;
        return this;
    }

    public ActionInstance<D> withLabel(@Nonnull Function<D, String> labelProvider) {
        this.labelProvider = labelProvider;
        return this;
    }

    public ActionInstance<D> withIcon(@Nonnull String icon) {
        this.iconProvider = any -> icon;
        return this;
    }

    public ActionInstance<D> withIcon(@Nonnull Function<D, String> iconProvider) {
        this.iconProvider = iconProvider;
        return this;
    }

    public ActionInstance<D> withTitle(@Nonnull AzureString title) {
        this.titleProvider = any -> title;
        return this;
    }

    public ActionInstance<D> withAuthRequired(boolean authRequired) {
        this.authRequiredProvider = ignore -> authRequired;
        return this;
    }

    public ActionInstance<D> withAuthRequired(@Nonnull Predicate<D> authRequiredProvider) {
        this.authRequiredProvider = authRequiredProvider;
        return this;
    }

    public ActionInstance<D> withIdParam(@Nonnull String titleParam) {
        this.titleParamProviders.add(d -> titleParam);
        return this;
    }

    public ActionInstance<D> withIdParam(@Nonnull Function<D, String> titleParamProvider) {
        this.titleParamProviders.add(titleParamProvider);
        return this;
    }

    @Generated
    public Action<D> getAction() {
        return this.action;
    }

    @Nullable
    @Generated
    public D getTarget() {
        return this.target;
    }

    @Nullable
    @Generated
    public Object getEvent() {
        return this.event;
    }
}

