/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.action;

import com.microsoft.azure.toolkit.lib.account.IAccount;
import com.microsoft.azure.toolkit.lib.common.action.ActionInstance;
import com.microsoft.azure.toolkit.lib.common.action.AzureActionManager;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResource;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import com.microsoft.azure.toolkit.lib.common.view.IView;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.PropertyKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Action<D>
implements Cloneable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Action.class);
    public static final String SOURCE = "ACTION_SOURCE";
    public static final String PLACE = "action_place";
    public static final String EMPTY_PLACE = "empty";
    public static final String RESOURCE_TYPE = "resourceType";
    public static final Id<Object> AUTHENTICATE = Id.of("user/account.authenticate");
    public static final Id<Consumer<IAccount>> REQUIRE_AUTH = Id.of("user/common.authorize_action");
    public static final Id<Object> TRY_AZURE = Id.of("user/account.try_azure");
    public static final Id<Object> SELECT_SUBS = Id.of("user/account.select_subs");
    public static final Id<Object> OPEN_AZURE_SETTINGS = Id.of("user/common.open_azure_settings");
    public static final Id<Object> DISABLE_AUTH_CACHE = Id.of("user/account.disable_auth_cache");
    public static final Id<Object> SIGN_IN = Id.of("user/common.sign_in");
    public static final Id<Object> SIGN_OUT = Id.of("user/common.sign_out");
    public static final Id<String> OPEN_URL = Id.of("user/common.open_url.url");
    public static final String COMMON_PLACE = "common";
    @Nonnull
    private final Id<D> id;
    @Nonnull
    private List<Pair<BiPredicate<D, ?>, BiConsumer<D, ?>>> handlers = new ArrayList();
    protected D target;
    @Nonnull
    Predicate<D> enableWhen = o -> true;
    BiPredicate<Object, String> visibleWhen = (o, place) -> true;
    Function<D, String> iconProvider;
    Function<D, String> labelProvider;
    Function<D, AzureString> titleProvider;
    @Nonnull
    List<Function<D, String>> titleParamProviders = new ArrayList<Function<D, String>>();
    Function<D, Object> sourceProvider;
    Predicate<D> authRequiredProvider = Action::isAuthRequiredForAzureResource;
    private Object shortcut;

    public Action(@Nonnull Id<D> id) {
        this.id = id;
    }

    public IView.Label getView(D s) {
        return this.getView(s, COMMON_PLACE);
    }

    @Nonnull
    public IView.Label getView(D s, String place) {
        ActionInstance<D> instance = this.instantiate(s, null);
        return instance.getView(place);
    }

    public void handle(D s) {
        this.handle(s, null);
    }

    public void handle(D s, Object e) {
        ActionInstance<D> instance = this.instantiate(s, e);
        instance.performAsync();
    }

    public void handleSync(D s) {
        this.handleSync(s, null);
    }

    public void handleSync(D s, Object e) {
        ActionInstance<D> instance = this.instantiate(s, e);
        instance.perform();
    }

    public Action<D> enableWhen(@Nonnull Predicate<D> enableWhen) {
        this.enableWhen = enableWhen;
        return this;
    }

    public Action<D> visibleWhen(@Nonnull Predicate<Object> visibleWhen) {
        this.visibleWhen = (object, ignore) -> visibleWhen.test(object);
        return this;
    }

    public Action<D> visibleWhen(@Nonnull BiPredicate<Object, String> visibleWhen) {
        this.visibleWhen = visibleWhen;
        return this;
    }

    public Action<D> withLabel(@Nonnull String label) {
        this.labelProvider = any -> label;
        return this;
    }

    public Action<D> withLabel(@Nonnull Function<D, String> labelProvider) {
        this.labelProvider = labelProvider;
        return this;
    }

    public Action<D> withIcon(@Nonnull String icon) {
        this.iconProvider = any -> icon;
        return this;
    }

    public Action<D> withIcon(@Nonnull Function<D, String> iconProvider) {
        this.iconProvider = iconProvider;
        return this;
    }

    public Action<D> withTitle(@Nonnull AzureString title) {
        this.titleProvider = any -> title;
        return this;
    }

    public Action<D> withShortcut(@Nonnull Object shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    public Action<D> withHandler(@Nonnull Consumer<D> handler) {
        this.handlers.add(Pair.of((d, e) -> true, (d, e) -> handler.accept(d)));
        return this;
    }

    public <E> Action<D> withHandler(@Nonnull BiConsumer<D, E> handler) {
        this.handlers.add(Pair.of((d, e) -> true, handler));
        return this;
    }

    public Action<D> withHandler(@Nonnull Predicate<D> condition, @Nonnull Consumer<D> handler) {
        this.handlers.add(Pair.of((d, e) -> condition.test(d), (d, e) -> handler.accept(d)));
        return this;
    }

    public <E> Action<D> withHandler(@Nonnull BiPredicate<D, E> condition, @Nonnull BiConsumer<D, E> handler) {
        this.handlers.add(Pair.of(condition, handler));
        return this;
    }

    public Action<D> withAuthRequired(boolean authRequired) {
        this.authRequiredProvider = ignore -> authRequired;
        return this;
    }

    public Action<D> withAuthRequired(@Nonnull Predicate<D> authRequiredProvider) {
        this.authRequiredProvider = authRequiredProvider;
        return this;
    }

    public Action<D> withIdParam(@Nonnull String titleParam) {
        this.titleParamProviders.add(d -> titleParam);
        return this;
    }

    public Action<D> withIdParam(@Nonnull Function<D, String> titleParamProvider) {
        this.titleParamProviders.add(titleParamProvider);
        return this;
    }

    public Action<D> withSource(@Nonnull Object source) {
        this.sourceProvider = any -> source;
        return this;
    }

    public Action<D> withSource(@Nonnull Function<D, Object> sourceProvider) {
        this.sourceProvider = sourceProvider;
        return this;
    }

    @Nullable
    BiConsumer<D, Object> getHandler(D s, Object e) {
        if (!this.visibleWhen.test(s, COMMON_PLACE) && !this.enableWhen.test(s)) {
            return null;
        }
        for (int i = this.handlers.size() - 1; i >= 0; --i) {
            Pair<BiPredicate<D, ?>, BiConsumer<D, ?>> p = this.handlers.get(i);
            BiPredicate condition = (BiPredicate)p.getKey();
            BiConsumer handler = (BiConsumer)p.getValue();
            try {
                if (!condition.test(s, e)) continue;
                return handler;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public Action<D> bind(D s) {
        try {
            Action clone = (Action)this.clone();
            clone.handlers = new ArrayList(this.handlers);
            clone.titleParamProviders = new ArrayList<Function<D, String>>(this.titleParamProviders);
            clone.target = s;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public ActionInstance<D> instantiate(D s) {
        return this.instantiate(s, null);
    }

    @Nonnull
    public ActionInstance<D> instantiate(D s, Object event) {
        D target = Optional.ofNullable(this.target).orElse(s);
        return new ActionInstance<D>(this, target, event);
    }

    public void register(AzureActionManager am) {
        am.registerAction(this);
    }

    public String toString() {
        return String.format("Action {id:'%s', bindTo: %s}", this.getId(), this.target);
    }

    public static Action<Void> retryFromFailure(@Nonnull Runnable handler) {
        return new Action<Void>(Id.of("user/common.retry")).withHandler((D v) -> handler.run()).withLabel("Retry");
    }

    public static <D> Boolean isAuthRequiredForAzureResource(@Nullable D resource) {
        return resource instanceof AbstractAzResource && ((AbstractAzResource)resource).isAuthRequired();
    }

    @Nonnull
    @Generated
    public Id<D> getId() {
        return this.id;
    }

    @Generated
    public Action<D> setShortcut(Object shortcut) {
        this.shortcut = shortcut;
        return this;
    }

    @Generated
    public Object getShortcut() {
        return this.shortcut;
    }

    public static class View
    implements IView.Label {
        public static View INVISIBLE = new View("", "", false, false, null);
        @Nonnull
        private final String label;
        private final String iconPath;
        private final boolean enabled;
        private boolean visible = true;
        @Nullable
        private AzureString title;

        public View(@Nonnull String label, String iconPath, boolean enabled, @Nullable AzureString title) {
            this(label, iconPath, enabled, true, title);
        }

        @Override
        public String getDescription() {
            return Optional.ofNullable(this.title).map(AzureString::toString).orElse(null);
        }

        @Override
        public void dispose() {
        }

        @Override
        @Nonnull
        @Generated
        public String getLabel() {
            return this.label;
        }

        @Override
        @Generated
        public String getIconPath() {
            return this.iconPath;
        }

        @Override
        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Override
        @Generated
        public boolean isVisible() {
            return this.visible;
        }

        @Nullable
        @Generated
        public AzureString getTitle() {
            return this.title;
        }

        @Generated
        public View(@Nonnull String label, String iconPath, boolean enabled) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
            this.iconPath = iconPath;
            this.enabled = enabled;
        }

        @Generated
        public View(@Nonnull String label, String iconPath, boolean enabled, boolean visible, @Nullable AzureString title) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            this.label = label;
            this.iconPath = iconPath;
            this.enabled = enabled;
            this.visible = visible;
            this.title = title;
        }
    }

    public static class Id<D>
    extends OperationBase.Id {
        @Nonnull
        private final String id;

        private Id(@Nonnull String id) {
            super(id);
            this.id = id;
        }

        public static <D> Id<D> of(@Nonnull @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.operation") @PropertyKey(resourceBundle="bundles.com.microsoft.azure.toolkit.operation") String id) {
            assert (StringUtils.isNotBlank((CharSequence)id)) : "action id can not be blank";
            return new Id<D>(id);
        }

        @Override
        public String toString() {
            return this.id;
        }

        @Nonnull
        @Generated
        public String getId() {
            return this.id;
        }
    }
}

