/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.resource;

import com.azure.core.util.paging.ContinuablePage;
import com.azure.resourcemanager.resources.ResourceManager;
import com.azure.resourcemanager.resources.models.Deployment;
import com.azure.resourcemanager.resources.models.Deployments;
import com.microsoft.azure.toolkit.lib.common.model.AbstractAzResourceModule;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeployment;
import com.microsoft.azure.toolkit.lib.resource.ResourceDeploymentDraft;
import com.microsoft.azure.toolkit.lib.resource.ResourceGroup;
import com.microsoft.azure.toolkit.lib.resource.ResourcesServiceSubscription;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class ResourceDeploymentModule
extends AbstractAzResourceModule<ResourceDeployment, ResourceGroup, Deployment> {
    public static final String NAME = "deployments";

    public ResourceDeploymentModule(@Nonnull ResourceGroup parent) {
        super(NAME, parent);
    }

    @Nullable
    public Deployments getClient() {
        return Optional.ofNullable(((ResourcesServiceSubscription)((ResourceGroup)this.parent).getParent()).getRemote()).map(ResourceManager::deployments).orElse(null);
    }

    @Nonnull
    protected ResourceDeploymentDraft newDraftForCreate(@Nonnull String name, @Nullable String resourceGroupName) {
        assert (resourceGroupName != null) : "'Resource group' is required.";
        return new ResourceDeploymentDraft(name, resourceGroupName, this);
    }

    @Nonnull
    protected ResourceDeploymentDraft newDraftForUpdate(@Nonnull ResourceDeployment origin) {
        return new ResourceDeploymentDraft(origin);
    }

    @Override
    @Nonnull
    protected Iterator<? extends ContinuablePage<String, Deployment>> loadResourcePagesFromAzure() {
        return Optional.ofNullable(this.getClient()).map(c -> c.listByResourceGroup(((ResourceGroup)this.parent).getName()).iterableByPage(ResourceDeploymentModule.getPageSize()).iterator()).orElse(Collections.emptyIterator());
    }

    @Override
    @Nonnull
    public String toResourceId(@Nonnull String resourceName, @Nullable String resourceGroup) {
        resourceGroup = (String)StringUtils.firstNonBlank((CharSequence[])new String[]{resourceGroup, ((ResourceGroup)this.getParent()).getResourceGroupName(), "${rg}"});
        return String.format("/subscriptions/%s/resourceGroups/%s/providers/Microsoft.Resources/%s/%s", this.getSubscriptionId(), ((ResourceGroup)this.parent).getResourceGroupName(), this.getName(), resourceName).replace("${rg}", resourceGroup);
    }

    @Override
    @Nonnull
    protected ResourceDeployment newResource(@Nonnull Deployment r) {
        return new ResourceDeployment(r, this);
    }

    @Override
    @Nonnull
    protected ResourceDeployment newResource(@Nonnull String name, @Nullable String resourceGroupName) {
        return new ResourceDeployment(name, Objects.requireNonNull(resourceGroupName), this);
    }

    @Override
    @Nonnull
    public String getResourceTypeName() {
        return "Resource deployment";
    }
}

