/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.validator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitRuntimeException;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.validator.ValidationMessage;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public class SchemaValidator {
    private static final Path SCHEMA_ROOT = Paths.get("schema", new String[0]);
    private static final String INVALID_PARAMETER_ERROR_MESSAGE = "Invalid parameters founded, please correct the value with messages below:";
    private final Map<String, JsonSchema> schemaMap = new HashMap<String, JsonSchema>();
    private final JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V7);
    private final ObjectMapper objectMapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_EMPTY).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_CREATORS, MapperFeature.AUTO_DETECT_GETTERS, MapperFeature.AUTO_DETECT_IS_GETTERS});

    static {
        System.setProperty("org.slf4j.simpleLogger.log.com.networknt.schema.JsonMetaSchema", "error");
        System.setProperty("org.slf4j.simpleLogger.log.org.reflections.Reflections", "warn");
    }

    private SchemaValidator() {
        Optional.of(new Reflections("schema", new Scanner[]{Scanners.Resources})).map(reflections -> {
            try {
                return reflections.getResources(".*\\.json");
            }
            catch (Exception exception) {
                return null;
            }
        }).orElse(Collections.emptySet()).stream().map(resource -> Pair.of((Object)resource, (Object)SchemaValidator.class.getResourceAsStream("/" + resource))).filter(pair -> pair.getValue() != null).forEach(pair -> this.registerSchema(SchemaValidator.getSchemaId((String)pair.getKey()), (InputStream)pair.getValue()));
    }

    public static SchemaValidator getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void registerSchema(@Nonnull String schemaId, @Nonnull JsonNode schema) {
        if (this.schemaMap.containsKey(schemaId)) {
            AzureMessager.getMessager().info(AzureString.format("Updating schema for %s", schemaId));
        }
        this.schemaMap.put(schemaId, this.factory.getSchema(schema));
    }

    public void registerSchema(@Nonnull String schemaId, @Nonnull InputStream schema) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream inputStream = schema;){
                JsonNode schemaNode = this.objectMapper.readTree(inputStream);
                this.registerSchema(schemaId, schemaNode);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            AzureMessager.getMessager().warning(AzureString.format("Failed to load configuration schema %s", schemaId));
        }
    }

    public List<ValidationMessage> validate(@Nonnull String schemaId, @Nonnull Object value) {
        return this.validate(schemaId, value, "$");
    }

    public List<ValidationMessage> validate(@Nonnull String schemaId, @Nonnull Object value, @Nullable String pathPrefix) {
        return this.validate(schemaId, (JsonNode)this.objectMapper.convertValue(value, JsonNode.class), pathPrefix);
    }

    public List<ValidationMessage> validate(@Nonnull String schemaId, @Nonnull JsonNode value, @Nullable String pathPrefix) {
        if (!this.schemaMap.containsKey(schemaId)) {
            AzureMessager.getMessager().warning(AzureString.format("Skip validation as schema %s was not registered", schemaId));
            return Collections.emptyList();
        }
        return this.schemaMap.get(schemaId).validate(value, value, pathPrefix).stream().map(ValidationMessage::fromRawMessage).collect(Collectors.toList());
    }

    public void validateAndThrow(@Nonnull String schemaId, @Nonnull Object value) {
        this.validateAndThrow(schemaId, value, "$");
    }

    public void validateAndThrow(@Nonnull String schemaId, @Nonnull Object value, @Nullable String pathPrefix) {
        this.validateAndThrow(schemaId, (JsonNode)this.objectMapper.convertValue(value, JsonNode.class), pathPrefix);
    }

    public void validateAndThrow(@Nonnull String schemaId, @Nonnull JsonNode value, @Nullable String pathPrefix) {
        List<ValidationMessage> result = this.validate(schemaId, value, pathPrefix);
        if (CollectionUtils.isNotEmpty(result)) {
            String errorDetails = result.stream().map(message -> message.getMessage().toString()).collect(Collectors.joining("\n"));
            throw new AzureToolkitRuntimeException(String.join((CharSequence)"\n", INVALID_PARAMETER_ERROR_MESSAGE, errorDetails));
        }
    }

    private static String getSchemaId(String path) {
        try {
            Path schemaPath = Paths.get(FilenameUtils.removeExtension((String)path), new String[0]);
            Path relativePath = SCHEMA_ROOT.relativize(schemaPath);
            return FilenameUtils.separatorsToUnix((String)relativePath.toString());
        }
        catch (IllegalArgumentException e) {
            return path;
        }
    }

    /* synthetic */ SchemaValidator(SchemaValidator schemaValidator) {
        this();
    }

    private static class LazyHolder {
        static final SchemaValidator INSTANCE = new SchemaValidator(null);

        private LazyHolder() {
        }
    }
}

