/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils.aspect;

import com.microsoft.azure.toolkit.lib.common.exception.AzureToolkitException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Triple;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class MethodInvocation {
    protected final Method method;
    private final JoinPoint point;
    private final MethodSignature signature;

    MethodInvocation(JoinPoint point) {
        this.point = point;
        this.signature = (MethodSignature)this.point.getSignature();
        this.method = this.signature.getMethod();
    }

    @Nullable
    public Object invoke() throws Exception {
        if (this.point instanceof ProceedingJoinPoint) {
            try {
                return ((ProceedingJoinPoint)this.point).proceed();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new AzureToolkitException(t.getMessage(), t);
            }
        }
        return null;
    }

    public Object getInstance() {
        return this.point.getThis();
    }

    public List<Triple<String, Parameter, Object>> getArgs() {
        ArrayList<Triple<String, Parameter, Object>> result = new ArrayList<Triple<String, Parameter, Object>>();
        String[] names = this.signature.getParameterNames();
        Parameter[] params = this.method.getParameters();
        Object[] values = this.point.getArgs();
        int i = 0;
        while (i < params.length) {
            result.add((Triple<String, Parameter, Object>)Triple.of((Object)names[i], (Object)params[i], (Object)values[i]));
            ++i;
        }
        return result;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.method.getAnnotation(annotation);
    }

    public static MethodInvocation from(@Nonnull JoinPoint point) {
        return new MethodInvocation(point);
    }

    public static MethodInvocationBuilder builder() {
        return new MethodInvocationBuilder();
    }

    public Method getMethod() {
        return this.method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodInvocation)) {
            return false;
        }
        MethodInvocation other = (MethodInvocation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MethodInvocation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        return result;
    }

    public static class MethodInvocationBuilder {
        private JoinPoint point;

        MethodInvocationBuilder() {
        }

        public MethodInvocationBuilder point(JoinPoint point) {
            this.point = point;
            return this;
        }

        public MethodInvocation build() {
            return new MethodInvocation(this.point);
        }

        public String toString() {
            return "MethodInvocation.MethodInvocationBuilder(point=" + this.point + ")";
        }
    }
}

