/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.utils;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;

public class JsonUtils {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static <T> T deepCopyWithJson(T source) {
        return (T)JsonUtils.fromJson(JsonUtils.toJson(source), source.getClass());
    }

    public static void writeToJsonFile(File targetFile, Object json) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileWriter writer = new FileWriter(targetFile);){
            MAPPER.writeValue((Writer)writer, json);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    public static <T> T readFromJsonFile(File target, Class<T> clazz) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                Object object;
                InputStreamReader isr;
                FileInputStream fis;
                block18: {
                    block17: {
                        fis = new FileInputStream(target);
                        isr = new InputStreamReader(fis);
                        object = MAPPER.readValue((Reader)isr, clazz);
                        if (isr == null) break block17;
                        isr.close();
                    }
                    if (fis == null) break block18;
                    fis.close();
                }
                return (T)object;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (isr != null) {
                                isr.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        return (T)MAPPER.readValue(json, clazz);
    }

    public static <T> T fromJson(String json, TypeReference<T> type) {
        return (T)MAPPER.readValue(json, type);
    }

    public static String toJson(Object src) {
        return MAPPER.writeValueAsString(src);
    }
}

