/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.task;

import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.operation.OperationBase;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AzureTask<T>
extends OperationBase {
    @Nonnull
    private final Modality modality;
    @Nullable
    private final Callable<T> body;
    @Nullable
    private final Object project;
    private final boolean cancellable;
    @Nullable
    private final AzureString description;
    private boolean backgroundable = true;
    @Nullable
    private Boolean backgrounded = null;
    @Nonnull
    private String type = "ASYNC";
    private Monitor monitor;
    @Nullable
    private Object source;

    public AzureTask() {
        this((Callable<T>)null);
    }

    public AzureTask(@Nonnull Runnable runnable) {
        this(runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull String title, @Nonnull Runnable runnable) {
        this(title, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Runnable runnable) {
        this(title, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Callable<T> body) {
        this(body, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull String title, @Nonnull Callable<T> body) {
        this(null, title, false, body, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Callable<T> body) {
        this(null, title, false, body, Modality.DEFAULT);
    }

    public AzureTask(@Nonnull Runnable runnable, @Nonnull Modality modality) {
        this((Object)null, (String)null, false, runnable, modality);
    }

    public AzureTask(@Nonnull String title, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(null, title, false, runnable, modality);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(null, title, false, runnable, modality);
    }

    public AzureTask(@Nullable Callable<T> body, @Nonnull Modality modality) {
        this((Object)null, (String)null, false, body, modality);
    }

    public AzureTask(@Nonnull String title, @Nonnull Callable<T> body, @Nonnull Modality modality) {
        this(null, title, false, body, modality);
    }

    public AzureTask(@Nonnull AzureString title, @Nonnull Callable<T> body, @Nonnull Modality modality) {
        this(null, title, false, body, modality);
    }

    public AzureTask(@Nullable Object project, @Nonnull String title, boolean cancellable, @Nonnull Runnable runnable) {
        this(project, title, cancellable, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nonnull AzureString title, boolean cancellable, @Nonnull Runnable runnable) {
        this(project, title, cancellable, runnable, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nonnull String title, boolean cancellable, @Nonnull Callable<T> body) {
        this(project, title, cancellable, body, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nonnull AzureString title, boolean cancellable, @Nonnull Callable<T> body) {
        this(project, title, cancellable, body, Modality.DEFAULT);
    }

    public AzureTask(@Nullable Object project, @Nullable String title, boolean cancellable, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(project, (AzureString)Optional.ofNullable(title).map(AzureString::fromString).orElse(null), cancellable, runnable, modality);
    }

    public AzureTask(@Nullable Object project, @Nullable AzureString title, boolean cancellable, @Nonnull Runnable runnable, @Nonnull Modality modality) {
        this(project, title, cancellable, () -> {
            runnable.run();
            return null;
        }, modality);
    }

    public AzureTask(@Nullable Object project, @Nullable String title, boolean cancellable, @Nullable Callable<T> body, @Nonnull Modality modality) {
        this(project, (AzureString)Optional.ofNullable(title).map(AzureString::fromString).orElse(null), cancellable, body, modality);
    }

    public AzureTask(@Nullable Object project, @Nullable AzureString title, boolean cancellable, @Nullable Callable<T> body, @Nonnull Modality modality) {
        this.project = project;
        this.description = title;
        this.cancellable = cancellable;
        this.monitor = new DefaultMonitor();
        this.body = body;
        this.modality = modality;
    }

    @Override
    @Nonnull
    public String getId() {
        return Optional.ofNullable(this.getDescription()).map(AzureString::getName).orElse("<unknown>.<unknown>");
    }

    @Override
    @Nonnull
    public String getExecutionId() {
        return "&" + super.getExecutionId();
    }

    public String toString() {
        return String.format("{name:'%s'}", this.getId());
    }

    @Nonnull
    public Callable<T> getBody() {
        return Optional.ofNullable(this.body).orElse(this::doExecute);
    }

    public final T execute() {
        return this.getBody().call();
    }

    protected T doExecute() throws Exception {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Modality getModality() {
        return this.modality;
    }

    @Nullable
    public Object getProject() {
        return this.project;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    @Override
    @Nullable
    public AzureString getDescription() {
        return this.description;
    }

    public boolean isBackgroundable() {
        return this.backgroundable;
    }

    @Nullable
    public Boolean getBackgrounded() {
        return this.backgrounded;
    }

    @Override
    @Nonnull
    public String getType() {
        return this.type;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    @Override
    @Nullable
    public Object getSource() {
        return this.source;
    }

    public void setBackgroundable(boolean backgroundable) {
        this.backgroundable = backgroundable;
    }

    public void setBackgrounded(@Nullable Boolean backgrounded) {
        this.backgrounded = backgrounded;
    }

    public void setType(@Nonnull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    public void setMonitor(Monitor monitor) {
        this.monitor = monitor;
    }

    public void setSource(@Nullable Object source) {
        this.source = source;
    }

    public static class DefaultMonitor
    implements Monitor {
        private boolean cancelled = false;

        @Override
        public void cancel() {
            this.cancelled = true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }
    }

    public static enum Modality {
        DEFAULT,
        ANY,
        NONE;

    }

    public static interface Monitor {
        public void cancel();

        public boolean isCancelled();
    }
}

