/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.proxy;

import com.microsoft.azure.toolkit.lib.Azure;
import com.microsoft.azure.toolkit.lib.AzureConfiguration;
import com.microsoft.azure.toolkit.lib.common.bundle.AzureString;
import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.proxy.ProxyInfo;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ProxyManager {
    private static final String PROPERTY_USE_SYSTEM_PROXY = "java.net.useSystemProxies";
    private static final boolean isSystemProxyUnset = StringUtils.isBlank((CharSequence)System.getProperty("java.net.useSystemProxies"));
    private final ProxySelector defaultProxySelector = ProxySelector.getDefault();

    public boolean isProxyEnabled() {
        return StringUtils.isNotBlank((CharSequence)Azure.az().config().getProxySource());
    }

    public static ProxyManager getInstance() {
        return ProxyManagerHolder.INSTANCE;
    }

    public void applyProxy() {
        ProxyInfo proxy;
        final AzureConfiguration config = Azure.az().config();
        String source = config.getProxySource();
        if (StringUtils.isBlank((CharSequence)source) && (proxy = (ProxyInfo)ObjectUtils.firstNonNull((Object[])new ProxyInfo[]{ProxyManager.getProxyFromProgramArgument("http"), ProxyManager.getProxyFromProgramArgument("https"), this.getSystemProxy()})) != null) {
            config.setProxyInfo(proxy);
            source = config.getProxySource();
        }
        if (StringUtils.isNotBlank((CharSequence)source)) {
            final String proxyHost = config.getHttpProxyHost();
            int proxyPort = config.getHttpProxyPort();
            AzureMessager.getMessager().info(AzureString.format("Use %s proxy: %s", source, String.valueOf(proxyHost) + ":" + proxyPort));
            if (!StringUtils.equals((CharSequence)source, (CharSequence)"system") && !StringUtils.equals((CharSequence)source, (CharSequence)"intellij")) {
                final Proxy proxy2 = ProxyManager.createHttpProxy(proxyHost, proxyPort);
                ProxySelector.setDefault(new ProxySelector(){

                    @Override
                    public List<Proxy> select(URI uri) {
                        if (uri == null) {
                            throw new IllegalArgumentException("URI can't be null.");
                        }
                        String protocol = uri.getScheme();
                        String host = uri.getHost();
                        if (protocol == null || host == null) {
                            throw new IllegalArgumentException("protocol = " + protocol + " host = " + host);
                        }
                        if (ProxyManager.shouldNotUseProxyFor(ProxyManager.toPattern(Optional.ofNullable(config.getNonProxyHosts()).orElse("")), host.toLowerCase())) {
                            return Collections.singletonList(Proxy.NO_PROXY);
                        }
                        return Collections.singletonList(proxy2);
                    }

                    @Override
                    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
                    }
                });
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{config.getProxyUsername(), config.getProxyPassword()})) {
                    Authenticator.setDefault(new Authenticator(){

                        @Override
                        public PasswordAuthentication getPasswordAuthentication() {
                            if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(proxyHost)) {
                                return new PasswordAuthentication(config.getProxyUsername(), config.getProxyPassword().toCharArray());
                            }
                            return null;
                        }
                    });
                }
            }
        }
    }

    public void resetProxy() {
        ProxySelector.setDefault(this.defaultProxySelector);
    }

    private ProxyInfo getSystemProxy() {
        if (isSystemProxyUnset) {
            System.setProperty(PROPERTY_USE_SYSTEM_PROXY, "true");
        }
        ProxyInfo proxy = ProxyManager.getSystemProxyInner();
        if (isSystemProxyUnset) {
            System.clearProperty(PROPERTY_USE_SYSTEM_PROXY);
        }
        return proxy;
    }

    private static ProxyInfo getProxyFromProgramArgument(String prefix) {
        String proxyHost = System.getProperty(String.valueOf(prefix) + ".proxyHost");
        String proxyPort = System.getProperty(String.valueOf(prefix) + ".proxyPort");
        String proxyUser = System.getProperty(String.valueOf(prefix) + ".proxyUser");
        String proxyPassword = System.getProperty(String.valueOf(prefix) + ".proxyPassword");
        String nonProxyHosts = System.getProperty(String.valueOf(prefix) + ".nonProxyHosts");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{proxyHost, proxyPort}) && NumberUtils.isCreatable((String)proxyPort)) {
            return ((ProxyInfo.ProxyInfoBuilder)((ProxyInfo.ProxyInfoBuilder)((ProxyInfo.ProxyInfoBuilder)((ProxyInfo.ProxyInfoBuilder)((ProxyInfo.ProxyInfoBuilder)((ProxyInfo.ProxyInfoBuilder)ProxyInfo.builder().source(String.format("${%s}", String.valueOf(prefix) + ".proxyHost"))).host(proxyHost)).port(Integer.parseInt(proxyPort))).username(proxyUser)).password(proxyPassword)).nonProxyHosts(nonProxyHosts)).build();
        }
        return null;
    }

    private static Proxy createHttpProxy(String httpProxyHost, Integer httpProxyPort) {
        return StringUtils.isNotBlank((CharSequence)httpProxyHost) ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(httpProxyHost, (int)httpProxyPort)) : null;
    }

    private static ProxyInfo getSystemProxyInner() {
        URI uri = new URI("https://login.microsoft.com");
        for (Proxy proxy : ProxySelector.getDefault().select(uri)) {
            if (!(proxy.address() instanceof InetSocketAddress)) continue;
            InetSocketAddress address = (InetSocketAddress)proxy.address();
            return ((ProxyInfo.ProxyInfoBuilder)((ProxyInfo.ProxyInfoBuilder)((ProxyInfo.ProxyInfoBuilder)ProxyInfo.builder().source("system")).host(address.getHostName())).port(address.getPort())).build();
        }
        return null;
    }

    private static boolean shouldNotUseProxyFor(Pattern pattern, String urlhost) {
        if (pattern == null || urlhost.isEmpty()) {
            return false;
        }
        boolean matches = pattern.matcher(urlhost).matches();
        return matches;
    }

    private static Pattern toPattern(String mask) {
        boolean disjunctionEmpty = true;
        StringJoiner joiner = new StringJoiner("|");
        String[] stringArray = mask.split("\\|");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String disjunct = stringArray[n2];
            if (!disjunct.isEmpty()) {
                disjunctionEmpty = false;
                String regex = ProxyManager.disjunctToRegex(disjunct.toLowerCase());
                joiner.add(regex);
            }
            ++n2;
        }
        return disjunctionEmpty ? null : Pattern.compile(joiner.toString());
    }

    private static String disjunctToRegex(String disjunct) {
        String regex = "*".equals(disjunct) ? ".*" : (disjunct.startsWith("*") && disjunct.endsWith("*") ? ".*" + Pattern.quote(disjunct.substring(1, disjunct.length() - 1)) + ".*" : (disjunct.startsWith("*") ? ".*" + Pattern.quote(disjunct.substring(1)) : (disjunct.endsWith("*") ? String.valueOf(Pattern.quote(disjunct.substring(0, disjunct.length() - 1))) + ".*" : Pattern.quote(disjunct))));
        return regex;
    }

    private static class ProxyManagerHolder {
        private static final ProxyManager INSTANCE = new ProxyManager();

        private ProxyManagerHolder() {
        }
    }
}

