/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.operation;

import com.microsoft.azure.toolkit.lib.common.operation.Operation;
import com.microsoft.azure.toolkit.lib.common.operation.OperationListener;
import java.util.HashSet;
import java.util.Set;

public class OperationManager {
    private final Set<OperationListener> listeners = new HashSet<OperationListener>();

    private OperationManager() {
    }

    public static OperationManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void addListener(OperationListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(OperationListener listener) {
        this.listeners.remove(listener);
    }

    void fireBeforeEnter(Operation operation) {
        try {
            this.listeners.forEach(l -> l.beforeEnter(operation, operation.getSource()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void fireAfterReturning(Operation operation) {
        try {
            this.listeners.forEach(l -> l.afterReturning(operation, operation.getSource()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void fireAfterThrowing(Throwable e, Operation operation) {
        try {
            this.listeners.forEach(l -> l.afterThrowing(e, operation, operation.getSource()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /* synthetic */ OperationManager(OperationManager operationManager) {
        this();
    }

    private static class SingletonHolder {
        public static final OperationManager INSTANCE = new OperationManager(null);

        private SingletonHolder() {
        }
    }
}

