/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.model.page;

import com.azure.core.http.rest.Page;
import com.azure.core.util.IterableStream;
import java.util.Collections;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import reactor.core.publisher.Flux;

public class ItemPage<T>
implements Page<T> {
    private final IterableStream<T> items;

    public ItemPage(@Nonnull Iterable<T> items) {
        this.items = IterableStream.of(items);
    }

    public ItemPage(@Nonnull Stream<T> items) {
        this.items = new IterableStream(Flux.fromStream(items));
    }

    public static <T> ItemPage<T> emptyPage() {
        return new ItemPage(Collections.emptyList());
    }

    public IterableStream<T> getElements() {
        return this.items;
    }

    public String getContinuationToken() {
        return null;
    }
}

