/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.toolkit.lib.common.messager;

import com.microsoft.azure.toolkit.lib.common.messager.AzureMessager;
import com.microsoft.azure.toolkit.lib.common.messager.ExceptionNotification;
import java.lang.reflect.Method;
import java.util.stream.Stream;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public final class ExceptionNotificationAspect {
    private static final Logger log = LoggerFactory.getLogger(ExceptionNotificationAspect.class);
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static /* synthetic */ ExceptionNotificationAspect ajc$perSingletonInstance;

    static {
        try {
            ExceptionNotificationAspect.ajc$perSingletonInstance = new ExceptionNotificationAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    @Pointcut(value="execution(@com.microsoft.azure.toolkit.lib.common.messager.ExceptionNotification * *..*.*(..))")
    public void onException() {
    }

    @AfterThrowing(pointcut="onException()", throwing="e")
    public void afterThrowing(JoinPoint point, Throwable e) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        ExceptionNotification annotation = method.getAnnotation(ExceptionNotification.class);
        Class<Throwable>[] classes = annotation.value();
        if (Stream.of(classes).anyMatch(c -> c.isInstance(e))) {
            AzureMessager.getMessager().error(e);
            if (!annotation.throwAgain()) {
                return;
            }
        }
        throw e;
    }

    public static ExceptionNotificationAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.microsoft.azure.toolkit.lib.common.messager.ExceptionNotificationAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

